/*
 * Decompiled with CFR 0.152.
 */
package step.core.access;

import ch.exense.commons.app.Configuration;
import java.util.ArrayList;
import java.util.List;
import step.core.access.Authenticator;
import step.core.access.Credentials;
import step.core.access.User;
import step.core.access.UserAccessor;
import step.core.access.UserAccessorImpl;
import step.core.deployment.Session;

public class AuthenticationManager {
    private final Configuration configuration;
    private final Authenticator authenticator;
    private final UserAccessor userAccessor;
    private final List<AuthenticationManagerListener> listeners = new ArrayList<AuthenticationManagerListener>();

    public AuthenticationManager(Configuration configuration, Authenticator authenticator, UserAccessor userAccessor) {
        this.configuration = configuration;
        this.authenticator = authenticator;
        this.userAccessor = userAccessor;
    }

    public boolean useAuthentication() {
        return this.configuration.getPropertyAsBoolean("authentication", true);
    }

    public boolean authenticate(Session session, Credentials credentials) {
        boolean authenticated = this.authenticator.authenticate(credentials);
        if (authenticated) {
            this.setUserToSession(session, credentials.getUsername());
            try {
                this.listeners.forEach(l -> l.onSuccessfulAuthentication(session));
            }
            catch (Exception e) {
                this.logoutSession(session);
                throw e;
            }
            return true;
        }
        return false;
    }

    protected void setUserToSession(Session session, String username) {
        session.setAuthenticated(true);
        User user = this.userAccessor.getByUsername(username);
        session.setUser(user);
    }

    protected void logoutSession(Session session) {
        session.setUser(null);
        session.setAuthenticated(false);
    }

    public synchronized void authenticateDefaultUserIfAuthenticationIsDisabled(Session session) {
        if (!session.isAuthenticated() && !this.useAuthentication()) {
            User user = this.userAccessor.getByUsername("admin");
            if (user == null) {
                user = AuthenticationManager.defaultAdminUser();
                this.userAccessor.save(user);
            }
            this.setUserToSession(session, "admin");
        }
    }

    public static User defaultAdminUser() {
        User user = new User();
        user.setUsername("admin");
        user.setRole("admin");
        user.setPassword(UserAccessorImpl.encryptPwd("init"));
        return user;
    }

    public boolean registerListener(AuthenticationManagerListener e) {
        return this.listeners.add(e);
    }

    public static interface AuthenticationManagerListener {
        public void onSuccessfulAuthentication(Session var1);
    }
}

