/*
 * Decompiled with CFR 0.152.
 */
package step.core.access;

import java.util.NoSuchElementException;
import step.core.access.AccessManager;
import step.core.access.Role;
import step.core.access.RoleProvider;
import step.core.access.RoleResolver;
import step.core.deployment.Session;

public class AccessManagerImpl
implements AccessManager {
    private final RoleProvider roleProvider;
    private RoleResolver roleResolver;

    public AccessManagerImpl(RoleProvider roleProvider, RoleResolver roleResolver) {
        this.roleProvider = roleProvider;
        this.roleResolver = roleResolver;
    }

    @Override
    public void setRoleResolver(RoleResolver roleResolver) {
        this.roleResolver = roleResolver;
    }

    @Override
    public boolean checkRightInContext(Session session, String right) {
        Role role = this.getRoleInContext(session);
        return role.getRights().contains(right);
    }

    @Override
    public Role getRoleInContext(Session session) {
        String roleName = this.roleResolver.getRoleInContext(session);
        try {
            Role role = this.roleProvider.getRoles().stream().filter(r -> roleName.equals(r.getAttributes().get("name"))).findFirst().get();
            return role;
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("The role " + roleName + " doesn't exist");
        }
    }
}

