/*
 * Decompiled with CFR 0.152.
 */
package step.core;

import ch.exense.commons.app.Configuration;
import java.io.IOException;
import java.util.List;
import org.eclipse.jetty.server.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.access.User;
import step.core.access.UserAccessorImpl;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.MongoClientSession;
import step.core.accessors.PlanAccessorImpl;
import step.core.accessors.collections.Collection;
import step.core.accessors.collections.CollectionRegistry;
import step.core.artefacts.reports.ReportNodeAccessorImpl;
import step.core.dynamicbeans.DynamicBeanResolver;
import step.core.dynamicbeans.DynamicValueResolver;
import step.core.execution.EventManager;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionAccessor;
import step.core.execution.model.ExecutionAccessorImpl;
import step.core.execution.model.ExecutionStatus;
import step.core.plugins.ControllerPluginCallbacks;
import step.core.plugins.ControllerPluginManager;
import step.core.repositories.RepositoryObjectManager;
import step.core.scheduler.ExecutionScheduler;
import step.core.scheduler.ExecutionTaskAccessorImpl;
import step.expressions.ExpressionHandler;

public class Controller {
    private static final Logger logger = LoggerFactory.getLogger(Controller.class);
    private Configuration configuration;
    private GlobalContext context;
    private ControllerPluginManager pluginManager;
    private ExecutionScheduler scheduler;
    private ServiceRegistrationCallback serviceRegistrationCallback;
    private MongoClientSession mongoClientSession;

    public Controller(Configuration configuration) {
        this.configuration = configuration;
    }

    public void init(ServiceRegistrationCallback serviceRegistrationCallback) throws Exception {
        this.serviceRegistrationCallback = serviceRegistrationCallback;
        this.pluginManager = new ControllerPluginManager(this.configuration);
        this.pluginManager.initialize();
        this.initContext();
        this.context.setServiceRegistrationCallback(serviceRegistrationCallback);
        this.recover();
        ControllerPluginCallbacks pluginProxy = this.pluginManager.getProxy();
        logger.info("Starting controller...");
        pluginProxy.executionControllerStart(this.context);
        logger.info("Initializing data...");
        pluginProxy.initializeData(this.context);
        logger.info("Calling post data initialization scripts...");
        pluginProxy.afterInitializeData(this.context);
        this.scheduler = new ExecutionScheduler(this.context);
        this.scheduler.start();
    }

    private void initContext() {
        this.context = new GlobalContext();
        this.context.setPluginManager(this.pluginManager);
        this.mongoClientSession = new MongoClientSession(this.configuration);
        this.context.setConfiguration(this.configuration);
        this.context.setMongoClientSession(this.mongoClientSession);
        CollectionRegistry collectionRegistry = new CollectionRegistry();
        this.context.put(CollectionRegistry.class, collectionRegistry);
        this.context.setExecutionAccessor(new ExecutionAccessorImpl(this.mongoClientSession));
        this.context.setPlanAccessor(new PlanAccessorImpl(this.mongoClientSession));
        this.context.setReportAccessor(new ReportNodeAccessorImpl(this.mongoClientSession));
        this.context.setScheduleAccessor(new ExecutionTaskAccessorImpl(this.mongoClientSession));
        this.context.setUserAccessor(new UserAccessorImpl(this.mongoClientSession));
        collectionRegistry.register("users", new Collection<User>(this.mongoClientSession.getMongoDatabase(), "users", User.class, false));
        this.context.setRepositoryObjectManager(new RepositoryObjectManager(this.context.getPlanAccessor()));
        this.context.setExpressionHandler(new ExpressionHandler(this.configuration.getProperty("tec.expressions.scriptbaseclass"), this.configuration.getPropertyAsInteger("tec.expressions.warningthreshold"), this.configuration.getPropertyAsInteger("tec.expressions.pool.maxtotal", Integer.valueOf(1000)).intValue(), this.configuration.getPropertyAsInteger("tec.expressions.pool.maxidle", Integer.valueOf(-1)).intValue()));
        this.context.setDynamicBeanResolver(new DynamicBeanResolver(new DynamicValueResolver(this.context.getExpressionHandler())));
        this.context.setEventManager(new EventManager());
        this.createOrUpdateIndexes();
    }

    private void createOrUpdateIndexes() {
        long dataTTL = this.context.getConfiguration().getPropertyAsInteger("db.datattl", Integer.valueOf(0)).intValue();
        this.context.getReportAccessor().createIndexesIfNeeded(Long.valueOf(dataTTL));
        this.context.getExecutionAccessor().createIndexesIfNeeded(Long.valueOf(dataTTL));
    }

    public void destroy() {
        this.scheduler.shutdown();
        this.serviceRegistrationCallback.stop();
        this.pluginManager.getProxy().executionControllerDestroy(this.context);
        if (this.mongoClientSession != null) {
            try {
                this.mongoClientSession.close();
            }
            catch (IOException e) {
                logger.error("Error while closing mongo client", (Throwable)e);
            }
        }
    }

    private void recover() {
        ExecutionAccessor accessor = this.context.getExecutionAccessor();
        List executions = accessor.getActiveTests();
        if (executions != null && executions.size() > 0) {
            logger.warn("Found " + executions.size() + " executions in an incosistent state. The system might not have been shutdown cleanly or crashed.Starting recovery...");
            for (Execution e : executions) {
                logger.warn("Recovering test execution " + e.toString());
                logger.debug("Setting status to ENDED. TestExecutionID:" + e.getId().toString());
                e.setStatus(ExecutionStatus.ENDED);
                e.setEndTime(System.currentTimeMillis());
                accessor.save((AbstractIdentifiableObject)e);
            }
            logger.debug("Recovery ended.");
        }
    }

    public GlobalContext getContext() {
        return this.context;
    }

    public ExecutionScheduler getScheduler() {
        return this.scheduler;
    }

    public static interface ServiceRegistrationCallback {
        public void registerService(Class<?> var1);

        public void registerHandler(Handler var1);

        public void stop();
    }
}

