/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution.table;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import step.core.GlobalContext;
import step.core.accessors.collections.Collection;
import step.core.accessors.collections.DateRangeCriterium;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.model.ExecutionStatus;
import step.core.execution.table.ExecutionSummaryProvider;
import step.core.execution.table.ExecutionWrapper;
import step.core.execution.table.RootReportNodeProvider;

public class ExecutionCollection
extends Collection<ExecutionWrapper> {
    private final ExecutionSummaryProvider executionSummaryFormatter;
    private final RootReportNodeProvider rootReportNodeFormatter;

    public ExecutionCollection(GlobalContext context) {
        super(context.getMongoClientSession().getMongoDatabase(), "executions", ExecutionWrapper.class, true);
        ExecutionSummaryProvider executionSummaryFormatter;
        RootReportNodeProvider rootReportNodeFormatter = new RootReportNodeProvider(context);
        this.executionSummaryFormatter = executionSummaryFormatter = new ExecutionSummaryProvider(context);
        this.rootReportNodeFormatter = rootReportNodeFormatter;
    }

    @Override
    public ExecutionWrapper enrichEntity(ExecutionWrapper execution) {
        execution.setRootReportNode(this.rootReportNodeFormatter.getRootReportNode(execution));
        Object executionSummary = this.executionSummaryFormatter.format(execution);
        execution.setExecutionSummary(executionSummary);
        return execution;
    }

    @Override
    public List<String> distinct(String key) {
        if (key.equals("result")) {
            return Arrays.asList(ReportNodeStatus.values()).stream().map(Object::toString).collect(Collectors.toList());
        }
        if (key.equals("status")) {
            return Arrays.asList(ExecutionStatus.values()).stream().map(Object::toString).collect(Collectors.toList());
        }
        return super.distinct(key);
    }

    @Override
    public Bson getQueryFragmentForColumnSearch(String columnName, String searchValue) {
        if (columnName.equals("startTime") || columnName.equals("endTime")) {
            Bson queryFragment = new DateRangeCriterium("dd.MM.yyyy").createQuery(columnName, searchValue);
            return queryFragment;
        }
        return super.getQueryFragmentForColumnSearch(columnName, searchValue);
    }

    @Override
    public Class<?> getEntityClass() {
        return ExecutionWrapper.class;
    }
}

