/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.List;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.bson.Document;
import org.bson.conversions.Bson;
import step.core.accessors.collections.CollectionQueryFactory;

public class LeafReportNodesFilter
implements CollectionQueryFactory {
    protected List<String[]> optionalReportNodesFilter = new ArrayList<String[]>();

    public LeafReportNodesFilter(List<String[]> optionalReportNodesFilter) {
        this.optionalReportNodesFilter = optionalReportNodesFilter;
    }

    @Override
    public Bson buildAdditionalQuery(JsonObject filter) {
        ArrayList<Object> fragments = new ArrayList<Object>();
        if (filter != null && filter.containsKey((Object)"eid")) {
            fragments.add(new Document("executionID", (Object)filter.getString("eid")));
        }
        ArrayList<Document> nodeFilters = new ArrayList<Document>();
        nodeFilters.add(new Document("_class", (Object)"step.artefacts.reports.CallFunctionReportNode"));
        nodeFilters.add(new Document("error.root", (Object)true));
        if (this.optionalReportNodesFilter != null) {
            for (String[] kv : this.optionalReportNodesFilter) {
                nodeFilters.add(new Document(kv[0], (Object)kv[1]));
            }
        }
        fragments.add(Filters.or(nodeFilters));
        if (filter != null && filter.containsKey((Object)"testcases")) {
            ArrayList testcaseIds = new ArrayList();
            filter.getJsonArray("testcases").forEach(v -> testcaseIds.add(((JsonString)v).getString()));
            fragments.add(Filters.in((String)"customAttributes.TestCase", testcaseIds));
        }
        return Filters.and(fragments);
    }
}

