/*
 * Decompiled with CFR 0.152.
 */
package step.core.deployment;

import ch.exense.commons.app.Configuration;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import step.core.GlobalContext;
import step.core.access.AccessConfiguration;
import step.core.access.AccessManager;
import step.core.access.AuthenticationManager;
import step.core.access.Credentials;
import step.core.access.Role;
import step.core.access.RoleProvider;
import step.core.access.User;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.deployment.Session;

@Singleton
@Path(value="/access")
public class AccessServices
extends AbstractServices {
    private RoleProvider roleProvider;
    private AuthenticationManager authenticationManager;
    private AccessManager accessManager;

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
        GlobalContext context = this.controller.getContext();
        this.roleProvider = (RoleProvider)context.get(RoleProvider.class);
        this.authenticationManager = (AuthenticationManager)context.get(AuthenticationManager.class);
        this.accessManager = (AccessManager)context.get(AccessManager.class);
    }

    @POST
    @Path(value="/login")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response authenticateUser(Credentials credentials) {
        Session session = this.getSession();
        boolean authenticated = this.authenticationManager.authenticate(session, credentials);
        if (authenticated) {
            SessionResponse sessionResponse = this.buildSessionResponse(session);
            return Response.ok((Object)sessionResponse).build();
        }
        return Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).entity((Object)"Invalid username/password").type("text/plain").build();
    }

    @GET
    @Secured
    @Path(value="/session")
    public SessionResponse getCurrentSession() {
        Session session = this.getSession();
        return this.buildSessionResponse(session);
    }

    protected SessionResponse buildSessionResponse(Session session) {
        User user = session.getUser();
        Role role = this.accessManager.getRoleInContext(session);
        return new SessionResponse(user.getUsername(), role);
    }

    @GET
    @Path(value="/conf")
    public AccessConfiguration getAccessConfiguration() {
        AccessConfiguration conf = new AccessConfiguration();
        conf.setDemo(this.isDemo());
        conf.setAuthentication(this.authenticationManager.useAuthentication());
        conf.setRoles(this.roleProvider.getRoles().stream().map(r -> (String)r.getAttributes().get("name")).collect(Collectors.toList()));
        Configuration ctrlConf = this.getContext().getConfiguration();
        conf.getMiscParams().put("enforceschemas", this.getContext().getConfiguration().getProperty("enforceschemas", "false"));
        if (ctrlConf.hasProperty("ui.default.url")) {
            conf.setDefaultUrl(ctrlConf.getProperty("ui.default.url"));
        }
        conf.setDebug(ctrlConf.getPropertyAsBoolean("ui.debug", false));
        conf.setTitle(ctrlConf.getProperty("ui.title", "STEP"));
        return conf;
    }

    @POST
    @Secured
    @Path(value="/logout")
    public void logout() {
        this.setSession(null);
    }

    public boolean isDemo() {
        return this.configuration.getPropertyAsBoolean("demo", false);
    }

    public static class SessionResponse {
        private String username;
        private Role role;

        public SessionResponse(String username, Role role) {
            this.username = username;
            this.role = role;
        }

        public String getUsername() {
            return this.username;
        }

        public Role getRole() {
            return this.role;
        }
    }
}

