/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors.collections;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.Filters;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.json.JsonObject;
import org.bson.Document;
import org.jongo.Mapper;
import org.jongo.bson.Bson;
import org.jongo.marshall.Unmarshaller;
import org.jongo.marshall.jackson.JacksonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.accessors.AccessorLayerJacksonMapperProvider;
import step.core.accessors.collections.CollectionFind;
import step.core.accessors.collections.SearchOrder;
import step.core.accessors.collections.field.CollectionField;

public class Collection<T> {
    private static final Logger logger = LoggerFactory.getLogger(Collection.class);
    private static final int DEFAULT_LIMIT = 1000;
    protected static final String CSV_DELIMITER = ";";
    private final boolean filtered;
    private final Class<T> entityClass;
    private MongoCollection<BasicDBObject> collection;
    private Mapper dbLayerObjectMapper;

    public Collection(MongoDatabase mongoDatabase, String collectionName, Class<T> entityClass, boolean filtered) {
        this.filtered = filtered;
        this.entityClass = entityClass;
        this.collection = mongoDatabase.getCollection(collectionName, BasicDBObject.class);
        JacksonMapper.Builder builder2 = new JacksonMapper.Builder();
        AccessorLayerJacksonMapperProvider.getModules().forEach(m -> builder2.registerModule(m));
        this.dbLayerObjectMapper = builder2.build();
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public List<String> distinct(String columnName) {
        return (List)this.collection.distinct(columnName, String.class).filter((org.bson.conversions.Bson)new Document(columnName, (Object)new Document("$ne", null))).into(new ArrayList());
    }

    public CollectionFind<T> find(org.bson.conversions.Bson query, SearchOrder order, Integer skip, Integer limit) {
        return this.find(query, order, skip, limit, 0);
    }

    public CollectionFind<T> find(org.bson.conversions.Bson query, SearchOrder order, Integer skip, Integer limit, int maxTime) {
        MongoCursor iterator;
        long count = this.collection.estimatedDocumentCount();
        CountOptions option = new CountOptions();
        option.skip(0).limit(1000);
        long countResults = this.collection.countDocuments(query, option);
        FindIterable find = this.collection.find(query).maxTime((long)maxTime, TimeUnit.SECONDS);
        if (order != null) {
            Document sortDoc = new Document(order.getAttributeName(), (Object)order.getOrder());
            find.sort((org.bson.conversions.Bson)sortDoc);
        }
        if (skip != null) {
            find.skip(skip.intValue());
        }
        if (limit != null) {
            find.limit(limit.intValue());
        }
        try {
            iterator = find.iterator();
        }
        catch (MongoExecutionTimeoutException e) {
            logger.error("Query execution exceeded timeout of " + maxTime + " " + (Object)((Object)TimeUnit.SECONDS));
            throw e;
        }
        final Unmarshaller unmarshaller = this.dbLayerObjectMapper.getUnmarshaller();
        Iterator enrichedIterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                BasicDBObject next = (BasicDBObject)iterator.next();
                Object entity = unmarshaller.unmarshall(Bson.createDocument((DBObject)next), Collection.this.entityClass);
                entity = Collection.this.enrichEntity(entity);
                return entity;
            }
        };
        CollectionFind collectionFind = new CollectionFind(count, countResults, enrichedIterator);
        return collectionFind;
    }

    public List<org.bson.conversions.Bson> getAdditionalQueryFragments(JsonObject queryParameters) {
        return null;
    }

    public org.bson.conversions.Bson getQueryFragmentForColumnSearch(String columnName, String searchValue) {
        return Filters.regex((String)columnName, (String)searchValue);
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    protected T enrichEntity(T element) {
        return element;
    }

    public void export(org.bson.conversions.Bson query, Map<String, CollectionField> columns, PrintWriter writer) {
        FindIterable find = this.collection.find(query);
        MongoCursor iterator = find.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        BasicDBObject basicDBObject = (BasicDBObject)iterator.next();
        if (columns == null || columns.size() == 0) {
            columns = this.getExportFields();
        }
        if (columns == null || columns.size() == 0 && iterator.hasNext()) {
            columns = this.getExportFields();
            for (String key : basicDBObject.keySet()) {
                columns.put(key, new CollectionField(key, key));
            }
        }
        columns.values().forEach(v -> {
            String title = v.getTitle().replaceAll("^ID", "id");
            writer.print(title);
            writer.print(CSV_DELIMITER);
        });
        writer.println();
        this.dumpRow(basicDBObject, columns, writer);
        int count = 1;
        while (iterator.hasNext()) {
            ++count;
            basicDBObject = (BasicDBObject)iterator.next();
            this.dumpRow(basicDBObject, columns, writer);
        }
    }

    private void dumpRow(BasicDBObject basicDBObject, Map<String, CollectionField> fields, PrintWriter writer) {
        fields.forEach((key, field) -> {
            Object value = basicDBObject.get(key);
            if (value != null) {
                String valueStr = field.getFormat().format(value);
                if (valueStr.contains(CSV_DELIMITER) || valueStr.contains("\n") || valueStr.contains("\"")) {
                    valueStr = "\"" + valueStr.replaceAll("\"", "\"\"") + "\"";
                }
                writer.print(valueStr);
            }
            writer.print(CSV_DELIMITER);
        });
        writer.println();
    }

    protected Map<String, CollectionField> getExportFields() {
        HashMap<String, CollectionField> result = new HashMap<String, CollectionField>();
        return result;
    }
}

