/*
 * Decompiled with CFR 0.152.
 */
package step.core.repositories;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.artefacts.CallPlan;
import step.artefacts.TestCase;
import step.artefacts.TestSet;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactRegistry;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;
import step.core.execution.model.ReportExport;
import step.core.execution.model.ReportExportStatus;
import step.core.plans.Plan;
import step.core.plans.PlanAccessor;
import step.core.repositories.ArtefactInfo;
import step.core.repositories.ImportResult;
import step.core.repositories.Repository;
import step.core.repositories.RepositoryObjectReference;
import step.core.repositories.TestRunStatus;
import step.core.repositories.TestSetStatusOverview;

public class RepositoryObjectManager {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryObjectManager.class);
    public static final String CLIENT_KEY = "RepositoryObjectManager_Client";
    private Map<String, Repository> repositories = new ConcurrentHashMap<String, Repository>();
    private PlanAccessor planAccessor;
    private static final String LOCAL = "local";

    public RepositoryObjectManager(PlanAccessor planAccessor) {
        this.planAccessor = planAccessor;
    }

    public void registerRepository(String id, Repository repository) {
        this.repositories.put(id, repository);
    }

    public ImportResult importPlan(ExecutionContext context, RepositoryObjectReference artefact) throws Exception {
        String respositoryId = artefact.getRepositoryID();
        Repository repository = this.getRepository(respositoryId);
        return repository.importArtefact(context, artefact.getRepositoryParameters());
    }

    private Repository getRepository(String respositoryId) {
        Repository repository = this.repositories.get(respositoryId);
        if (repository == null) {
            throw new RuntimeException("Unknown repository '" + respositoryId + "'");
        }
        return repository;
    }

    public ReportExport exportTestExecutionReport(ExecutionContext context, RepositoryObjectReference report) {
        ReportExport export = new ReportExport();
        String respositoryId = report.getRepositoryID();
        if (!report.getRepositoryID().equals(LOCAL)) {
            Repository repository = this.getRepository(respositoryId);
            try {
                repository.exportExecution(context, report.getRepositoryParameters());
                export.setStatus(ReportExportStatus.SUCCESSFUL);
            }
            catch (Exception e) {
                export.setStatus(ReportExportStatus.FAILED);
                export.setError(e.getMessage() + ". See application logs for more details.");
                logger.error("Error while exporting test " + context.getExecutionId() + " to " + respositoryId, (Throwable)e);
            }
        }
        return export;
    }

    public ArtefactInfo getArtefactInfo(RepositoryObjectReference ref) throws Exception {
        try {
            if (ref.getRepositoryID().equals(LOCAL)) {
                String planId = (String)ref.getRepositoryParameters().get("planid");
                Plan plan = (Plan)this.planAccessor.get(planId);
                ArtefactInfo info = new ArtefactInfo();
                info.setName(plan.getAttributes() != null ? (String)plan.getAttributes().get("name") : null);
                info.setType(ArtefactRegistry.getArtefactName(plan.getRoot().getClass()));
                return info;
            }
            String respositoryId = ref.getRepositoryID();
            Repository repository = this.getRepository(respositoryId);
            return repository.getArtefactInfo(ref.getRepositoryParameters());
        }
        catch (Exception e) {
            logger.error("Error while getting artefact infos for " + ref, (Throwable)e);
            throw e;
        }
    }

    public TestSetStatusOverview getReport(RepositoryObjectReference report) throws Exception {
        if (!report.getRepositoryID().equals(LOCAL)) {
            String respositoryId = report.getRepositoryID();
            Repository repository = this.getRepository(respositoryId);
            return repository.getTestSetStatusOverview(report.getRepositoryParameters());
        }
        TestSetStatusOverview testSetStatusOverview = new TestSetStatusOverview();
        String planId = (String)report.getRepositoryParameters().get("planid");
        Plan plan = (Plan)this.planAccessor.get(planId);
        AbstractArtefact rootArtefact = plan.getRoot();
        if (rootArtefact instanceof TestSet) {
            List children = rootArtefact.getChildren();
            children.forEach(child -> {
                Plan referencedPlan;
                AbstractArtefact root;
                if (child instanceof TestCase) {
                    this.addTestRunStatus(testSetStatusOverview.getRuns(), (AbstractArtefact)child);
                } else if (child instanceof CallPlan && (root = (referencedPlan = (Plan)this.planAccessor.get(((CallPlan)child).getPlanId())).getRoot()) instanceof TestCase) {
                    this.addTestRunStatus(testSetStatusOverview.getRuns(), root);
                }
            });
        }
        return testSetStatusOverview;
    }

    private void addTestRunStatus(List<TestRunStatus> testRunStatusList, AbstractArtefact abstractArtefact) {
        testRunStatusList.add(new TestRunStatus(abstractArtefact.getId().toString(), (String)abstractArtefact.getAttributes().get("name"), ReportNodeStatus.NORUN));
    }
}

