/*
 * Decompiled with CFR 0.152.
 */
package step.core.export;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.deployment.JacksonMapperProvider;
import step.core.objectenricher.ObjectEnricher;
import step.core.plans.Plan;
import step.core.plans.PlanAccessor;

public class ImportManager {
    protected final PlanAccessor planAccessor;

    public ImportManager(PlanAccessor planAccessor) {
        this.planAccessor = planAccessor;
    }

    public void importPlans(File file, ObjectEnricher objectEnricher) throws IOException {
        ObjectMapper mapper = JacksonMapperProvider.createMapper();
        try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
            String line;
            while ((line = reader.readLine()) != null) {
                Plan plan = (Plan)mapper.readValue(line, Plan.class);
                objectEnricher.accept((Object)plan);
                this.planAccessor.save((AbstractIdentifiableObject)plan);
            }
        }
    }
}

