/*
 * Decompiled with CFR 0.152.
 */
package step.core.export;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.deployment.JacksonMapperProvider;
import step.core.objectenricher.ObjectPredicate;
import step.core.plans.Plan;
import step.core.plans.PlanAccessor;

public class ExportManager {
    private static final Logger logger = LoggerFactory.getLogger(ExportManager.class);
    PlanAccessor accessor;

    public ExportManager(PlanAccessor accessor) {
        this.accessor = accessor;
    }

    public void exportPlan(String planId, OutputStream outputStream) throws FileNotFoundException, IOException {
        ObjectMapper mapper = this.getMapper();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));){
            this.exportPlan(mapper, writer, new ObjectId(planId));
        }
        catch (Exception e) {
            logger.error("Error while exporting artefact with id " + planId, (Throwable)e);
        }
    }

    private ObjectMapper getMapper() {
        ObjectMapper mapper = JacksonMapperProvider.createMapper();
        mapper.getFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        return mapper;
    }

    public void exportAllPlans(OutputStream outputStream, ObjectPredicate objectPredicate) throws FileNotFoundException, IOException {
        ObjectMapper mapper = this.getMapper();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));){
            this.accessor.getAll().forEachRemaining(a -> {
                if (objectPredicate.test(a)) {
                    try {
                        this.exportPlan(mapper, writer, new ObjectId(a.getId().toString()));
                    }
                    catch (Exception e) {
                        logger.error("Error while exporting artfact " + a.getId().toString(), (Throwable)e);
                    }
                }
            });
        }
    }

    private void exportPlan(ObjectMapper mapper, Writer writer, ObjectId id) throws IOException {
        Plan plan = (Plan)this.accessor.get(id);
        mapper.writeValue(writer, (Object)plan);
        writer.write("\n");
    }
}

