/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution.table;

import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.Document;
import org.bson.conversions.Bson;
import step.core.GlobalContext;
import step.core.accessors.collections.Collection;
import step.core.accessors.collections.MultiTextCriterium;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.plugins.screentemplating.Input;
import step.plugins.screentemplating.ScreenTemplateManager;

public class ReportNodeCollection
extends Collection<ReportNode> {
    private final List<String> reportSearchAttributes = new ArrayList<String>();

    public ReportNodeCollection(GlobalContext context) {
        super(context.getMongoClientSession().getMongoDatabase(), "reports", ReportNode.class, false);
        ScreenTemplateManager screenTemplateManager = (ScreenTemplateManager)context.get(ScreenTemplateManager.class);
        if (screenTemplateManager != null) {
            for (Input input : screenTemplateManager.getInputsForScreen("functionTable", null, null)) {
                this.reportSearchAttributes.add("functionAttributes." + input.getId());
            }
        }
        this.reportSearchAttributes.add("input");
        this.reportSearchAttributes.add("output");
        this.reportSearchAttributes.add("error.msg");
        this.reportSearchAttributes.add("name");
    }

    @Override
    public Bson getQueryFragmentForColumnSearch(String columnName, String searchValue) {
        if (columnName.equals("step")) {
            Bson queryFragment = new MultiTextCriterium(this.reportSearchAttributes).createQuery(columnName, searchValue);
            return queryFragment;
        }
        if (columnName.equals("status")) {
            Bson filter = this.getReportNodeStatusFilterOrNull(searchValue);
            if (filter != null) {
                return filter;
            }
            if (searchValue.startsWith("(") && searchValue.endsWith(")")) {
                String[] split = searchValue.substring(1, searchValue.length() - 1).split("\\|");
                ArrayList fragments = new ArrayList();
                AtomicBoolean allFilterParsed = new AtomicBoolean(true);
                Arrays.asList(split).forEach(s -> {
                    Bson status = this.getReportNodeStatusFilterOrNull((String)s);
                    if (status == null) {
                        allFilterParsed.set(false);
                    } else {
                        fragments.add(status);
                    }
                });
                if (allFilterParsed.get()) {
                    return Filters.or(fragments);
                }
                return super.getQueryFragmentForColumnSearch(columnName, searchValue);
            }
            return super.getQueryFragmentForColumnSearch(columnName, searchValue);
        }
        return super.getQueryFragmentForColumnSearch(columnName, searchValue);
    }

    protected Bson getReportNodeStatusFilterOrNull(String searchValue) {
        try {
            ReportNodeStatus status = ReportNodeStatus.valueOf((String)searchValue);
            return new Document("status", (Object)status.toString());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public Class<?> getEntityClass() {
        return ReportNode.class;
    }
}

