/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.bson.types.ObjectId;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.deployment.AbstractServices;
import step.core.deployment.FindByCriteraParam;
import step.core.deployment.Secured;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionAccessor;
import step.core.execution.model.ExecutionAccessorImpl;
import step.core.repositories.RepositoryObjectReference;

@Singleton
@Path(value="executions")
public class ExecutionServices
extends AbstractServices {
    protected ExecutionAccessor executionAccessor;

    @Override
    @PostConstruct
    public void init() {
        this.executionAccessor = this.getContext().getExecutionAccessor();
    }

    @GET
    @Produces(value={"application/json"})
    @Secured(right="execution-read")
    public List<Execution> getAll(@QueryParam(value="skip") Integer skip, @QueryParam(value="limit") Integer limit) {
        if (skip != null && limit != null) {
            return this.executionAccessor.getRange(skip.intValue(), limit.intValue());
        }
        return this.getAll(0, 1000);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Secured(right="execution-read")
    public Execution get(@PathParam(value="id") String id) {
        return (Execution)this.executionAccessor.get(id);
    }

    @POST
    @Path(value="/search")
    @Secured(right="execution-read")
    public Execution get(Map<String, String> attributes) {
        return (Execution)this.executionAccessor.findByAttributes(attributes);
    }

    @POST
    @Path(value="/search/by/ref")
    @Produces(value={"application/json"})
    @Secured(right="execution-read")
    public List<Execution> getExecutionsByRepositoryObjectReference(RepositoryObjectReference objectReference) {
        List executionsByArtefactURL = this.getContext().getExecutionAccessor().getTestExecutionsByArtefactURL(objectReference);
        return executionsByArtefactURL;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/search/by/critera")
    @Secured(right="execution-read")
    public List<Execution> findByCritera(FindByCriteraParam param) {
        return ((ExecutionAccessorImpl)this.getContext().getExecutionAccessor()).findByCritera(param.getCriteria(), param.getStart().getTime(), param.getEnd().getTime(), param.getSkip(), param.getLimit());
    }

    @GET
    @Path(value="/{id}/statusdistribution")
    @Produces(value={"application/json"})
    @Secured(right="execution-read")
    public Map<ReportNodeStatus, Integer> getStatusReport(@PathParam(value="id") String executionID, @QueryParam(value="class") String reportNodeClass) {
        return this.getContext().getReportAccessor().getLeafReportNodesStatusDistribution(executionID, reportNodeClass);
    }

    @GET
    @Path(value="/{id}/reportnodes")
    @Produces(value={"application/json"})
    @Secured(right="execution-read")
    public List<ReportNode> getReportNodesByExecutionID(@PathParam(value="id") String executionID, @QueryParam(value="class") String reportNodeClass, @QueryParam(value="limit") int limit) {
        ArrayList<ReportNode> result = new ArrayList<ReportNode>();
        Iterator iterator = reportNodeClass != null ? this.getContext().getReportAccessor().getReportNodesByExecutionIDAndClass(executionID, reportNodeClass) : this.getContext().getReportAccessor().getReportNodesByExecutionID(executionID);
        for (int i = 0; iterator.hasNext() && i < limit; ++i) {
            result.add((ReportNode)iterator.next());
        }
        return result;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Secured(right="execution-write")
    public Execution save(Execution execution) {
        return (Execution)this.executionAccessor.save((AbstractIdentifiableObject)execution);
    }

    @DELETE
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Secured(right="execution-delete")
    public void delete(@PathParam(value="id") String id) {
        this.executionAccessor.remove(new ObjectId(id));
    }
}

