/*
 * Decompiled with CFR 0.152.
 */
package step.core.deployment;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ExtendedUriInfo;
import step.core.GlobalContext;
import step.core.access.AccessManager;
import step.core.access.AuthenticationManager;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.deployment.Session;

@Provider
@Priority(value=1000)
public class SecurityFilter
extends AbstractServices
implements ContainerRequestFilter {
    @Inject
    private ExtendedUriInfo extendendUriInfo;
    private AuthenticationManager authenticationManager;
    private AccessManager accessManager;

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
        GlobalContext context = this.getContext();
        this.accessManager = (AccessManager)context.get(AccessManager.class);
        this.authenticationManager = (AuthenticationManager)context.get(AuthenticationManager.class);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Session session = this.retrieveOrInitializeSession();
        this.authenticationManager.authenticateDefaultUserIfAuthenticationIsDisabled(session);
        Secured annotation = this.extendendUriInfo.getMatchedResourceMethod().getInvocable().getHandlingMethod().getAnnotation(Secured.class);
        if (annotation != null) {
            if (session.isAuthenticated()) {
                boolean hasRight;
                String right = annotation.right();
                if (right.length() > 0 && !(hasRight = this.accessManager.checkRightInContext(session, right))) {
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                }
            } else {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
        }
    }

    protected Session retrieveOrInitializeSession() {
        Session session = this.getSession();
        if (session == null) {
            session = new Session();
            this.setSession(session);
        }
        return session;
    }
}

