/*
 * Decompiled with CFR 0.152.
 */
package step.core.artefacts.reports;

import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.jongo.ResultHandler;
import step.commons.datatable.DataTable;
import step.commons.datatable.TableRow;
import step.core.accessors.AbstractCRUDAccessor;
import step.core.accessors.MongoClientSession;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeAccessor;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.artefacts.reports.ReportTreeAccessor;

public class ReportNodeAccessorImpl
extends AbstractCRUDAccessor<ReportNode>
implements ReportTreeAccessor,
ReportNodeAccessor {
    MongoCollection<Document> reports_ = this.getMongoCollection("reports");

    public ReportNodeAccessorImpl(MongoClientSession clientSession) {
        super(clientSession, "reports", ReportNode.class);
    }

    public void createIndexesIfNeeded(Long ttl) {
        ReportNodeAccessorImpl.createOrUpdateIndex(this.reports_, "parentID");
        ReportNodeAccessorImpl.createOrUpdateIndex(this.reports_, "executionTime");
        ReportNodeAccessorImpl.createOrUpdateCompoundIndex(this.reports_, "executionID", "status", "executionTime");
        ReportNodeAccessorImpl.createOrUpdateCompoundIndex(this.reports_, "executionID", "executionTime");
        ReportNodeAccessorImpl.createOrUpdateCompoundIndex(this.reports_, "executionID", "_class");
    }

    public List<ReportNode> getReportNodePath(ObjectId id) {
        LinkedList<ReportNode> result = new LinkedList<ReportNode>();
        this.appendParentNodeToPath(result, (ReportNode)this.get(id));
        return result;
    }

    private void appendParentNodeToPath(LinkedList<ReportNode> path, ReportNode node) {
        ReportNode parentNode;
        path.addFirst(node);
        if (node.getParentID() != null && (parentNode = (ReportNode)this.get(node.getParentID())) != null) {
            this.appendParentNodeToPath(path, parentNode);
        }
    }

    public Iterator<ReportNode> getChildren(ObjectId parentID) {
        return this.collection.find("{parentID: #}", new Object[]{parentID}).sort("{executionTime: 1}").as(ReportNode.class).iterator();
    }

    public Iterator<ReportNode> getChildren(ObjectId parentID, int skip, int limit) {
        return this.collection.find("{parentID: #}", new Object[]{parentID}).skip(skip).limit(limit).sort("{executionTime: 1}").as(ReportNode.class).iterator();
    }

    public Iterator<ReportNode> getReportNodesByExecutionID(String executionID) {
        assert (executionID != null);
        return this.collection.find("{executionID: #}", new Object[]{executionID}).sort("{executionTime: 1}").as(ReportNode.class).iterator();
    }

    public long countReportNodesByExecutionID(String executionID) {
        assert (executionID != null);
        return this.collection.count("{executionID: #}");
    }

    public Iterator<ReportNode> getReportNodesByExecutionIDAndClass(String executionID, String class_) {
        assert (executionID != null);
        return this.collection.find("{executionID: #, _class: #}", new Object[]{executionID, class_}).as(ReportNode.class).iterator();
    }

    public Iterator<ReportNode> getLeafReportNodesByExecutionID(String executionID) {
        assert (executionID != null);
        return this.collection.find("{executionID: #, $or: [ { _class: 'step.commons.model.report.CallFunctionReportNode' }, { status: 'TECHNICAL_ERROR'} ]}", new Object[]{executionID}).sort("{executionTime: 1}").as(ReportNode.class).iterator();
    }

    public Iterator<ReportNode> getReportNodesByExecutionIDAndCustomAttribute(String executionID, List<Map<String, String>> customAttributes) {
        assert (executionID != null);
        StringBuilder query = new StringBuilder();
        query.append("{$and:[{executionID: #},");
        if (customAttributes != null && customAttributes.size() > 0) {
            query.append("{$or: [");
            Iterator<Map<String, String>> it = customAttributes.iterator();
            while (it.hasNext()) {
                Map<String, String> customAttributeMap = it.next();
                Iterator<String> keyIt = customAttributeMap.keySet().iterator();
                while (keyIt.hasNext()) {
                    String key = keyIt.next();
                    query.append("{'customAttributes.").append(key).append("': '").append(customAttributeMap.get(key)).append("'}");
                    if (!keyIt.hasNext()) continue;
                    query.append(",");
                }
                if (!it.hasNext()) continue;
                query.append(",");
            }
            query.append("]}]}");
        }
        return this.collection.find(query.toString(), new Object[]{executionID}).sort("{executionTime: 1}").as(ReportNode.class).iterator();
    }

    public ReportNode getReportNodeByParentIDAndArtefactID(ObjectId parentID, ObjectId artefactID) {
        assert (parentID != null);
        assert (artefactID != null);
        return (ReportNode)this.collection.findOne("{parentID: #, artefactID: #}", new Object[]{parentID, artefactID}).as(ReportNode.class);
    }

    public Iterator<ReportNode> getReportNodesByExecutionIDAndArtefactID(String executionID, String artefactID) {
        assert (executionID != null);
        assert (artefactID != null);
        return this.collection.find("{executionID: #, artefactID: #}", new Object[]{executionID, new ObjectId(artefactID)}).as(ReportNode.class).iterator();
    }

    public Iterator<ReportNode> getFailedLeafReportNodesByExecutionID(String executionID) {
        assert (executionID != null);
        return this.collection.find("{executionID: #, $or: [ { _class: 'step.commons.model.report.CallFunctionReportNode', status: {$ne:'PASSED'}}, { status: 'TECHNICAL_ERROR'} ]}", new Object[]{executionID}).sort("{executionTime: 1}").as(ReportNode.class).iterator();
    }

    public DataTable getTimeBasedReport(String executionID, int resolution) {
        String reportNodeClass = "step.artefacts.collection.CallFunctionReportNode";
        DataTable t = new DataTable();
        final double normalizationFactor = 1.0 * (double)resolution / 1000.0;
        this.collection.aggregate("{$match:{executionID:'" + executionID + "',_class:'" + reportNodeClass + "'}}").and("{$group:{_id:{time:{$subtract:[\"$executionTime\",{$mod:[\"$executionTime\"," + resolution + "]}]}},value:{$sum:1}}}", new Object[0]).and("{$sort:{\"_id\":1}}", new Object[0]).map((ResultHandler)new ResultHandler<TableRow>(){

            public TableRow map(DBObject result) {
                Date date = new Date((Long)((DBObject)result.get("_id")).get("time"));
                double value = new Double(((Integer)result.get("value")).intValue()) / normalizationFactor;
                TableRow r = new TableRow(date, Double.valueOf(value));
                return r;
            }
        }).forEach(row -> t.addRow(row));
        return t;
    }

    public ReportNode getRootReportNode(String executionID) {
        assert (executionID != null);
        return (ReportNode)this.collection.findOne("{executionID: '" + executionID + "', parentID: null}").as(ReportNode.class);
    }

    public Map<ReportNodeStatus, Integer> getLeafReportNodesStatusDistribution(String executionID, String reportNodeClass) {
        HashMap<ReportNodeStatus, Integer> result = new HashMap<ReportNodeStatus, Integer>();
        for (ReportNodeStatusReportEntry entry : this.collection.aggregate("{$match:{executionID:'" + executionID + "',_class:'" + reportNodeClass + "'}}").and("{$group:{_id:'$status',sum:{$sum:1}}}", new Object[0]).as(ReportNodeStatusReportEntry.class)) {
            result.put(entry._id, entry.sum);
        }
        return result;
    }

    public Iterator<ReportNode> getChildren(String parentID) {
        return this.getChildren(new ObjectId(parentID));
    }

    public void removeNodesByExecutionID(String executionID) {
        assert (executionID != null);
        this.collection.remove("{executionID: #}", new Object[]{executionID});
    }

    public static class ReportNodeStatusReportEntry {
        ReportNodeStatus _id;
        int sum;

        public ReportNodeStatusReportEntry() {
        }

        public ReportNodeStatusReportEntry(ReportNodeStatus _id, int sum) {
            this._id = _id;
            this.sum = sum;
        }

        public ReportNodeStatus get_id() {
            return this._id;
        }

        public void set_id(ReportNodeStatus _id) {
            this._id = _id;
        }

        public int getSum() {
            return this.sum;
        }

        public void setSum(int sum) {
            this.sum = sum;
        }
    }
}

