/*
 * Decompiled with CFR 0.152.
 */
package step.core.access;

import ch.exense.commons.app.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.GlobalContextAware;
import step.core.access.AccessManager;
import step.core.access.AccessManagerImpl;
import step.core.access.AuthenticationManager;
import step.core.access.Authenticator;
import step.core.access.DefaultAuthenticator;
import step.core.access.DefaultRoleProvider;
import step.core.access.RoleProvider;
import step.core.access.RoleResolverImpl;
import step.core.plugins.AbstractControllerPlugin;
import step.core.plugins.Plugin;

@Plugin
public class SecurityPlugin
extends AbstractControllerPlugin {
    private static final Logger logger = LoggerFactory.getLogger(SecurityPlugin.class);
    private GlobalContext context;
    private Configuration configuration;

    @Override
    public void executionControllerStart(GlobalContext context) throws Exception {
        this.context = context;
        this.configuration = context.getConfiguration();
        Authenticator authenticator = this.initAuthenticator();
        AuthenticationManager authenticationManager = new AuthenticationManager(this.configuration, authenticator, context.getUserAccessor());
        context.put(AuthenticationManager.class, authenticationManager);
        RoleProvider roleProvider = this.initAccessManager();
        context.put(RoleProvider.class, roleProvider);
        RoleResolverImpl roleResolver = new RoleResolverImpl(context.getUserAccessor());
        AccessManagerImpl accessManager = new AccessManagerImpl(roleProvider, roleResolver);
        context.put(AccessManager.class, accessManager);
        super.executionControllerStart(context);
    }

    private Authenticator initAuthenticator() throws Exception {
        Authenticator authenticator;
        String authenticatorClass = this.configuration.getProperty("ui.authenticator", null);
        if (authenticatorClass == null) {
            authenticator = new DefaultAuthenticator();
        } else {
            try {
                authenticator = (Authenticator)this.getClass().getClassLoader().loadClass(authenticatorClass).newInstance();
            }
            catch (Exception e) {
                logger.error("Error while initializing authenticator '" + authenticatorClass + "'", (Throwable)e);
                throw e;
            }
        }
        if (authenticator instanceof GlobalContextAware) {
            ((GlobalContextAware)((Object)authenticator)).setGlobalContext(this.context);
        }
        return authenticator;
    }

    private RoleProvider initAccessManager() throws Exception {
        RoleProvider roleProvider;
        String accessManagerClass = this.configuration.getProperty("ui.roleprovider", null);
        if (accessManagerClass == null) {
            roleProvider = new DefaultRoleProvider();
        } else {
            try {
                roleProvider = (RoleProvider)this.getClass().getClassLoader().loadClass(accessManagerClass).newInstance();
            }
            catch (Exception e) {
                logger.error("Error while initializing access manager '" + accessManagerClass + "'", (Throwable)e);
                throw e;
            }
        }
        if (roleProvider instanceof GlobalContextAware) {
            ((GlobalContextAware)((Object)roleProvider)).setGlobalContext(this.context);
        }
        return roleProvider;
    }
}

