/*
 * Decompiled with CFR 0.152.
 */
package step.core.dynamicbeans;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import step.core.dynamicbeans.DynamicBeanResolver;
import step.core.dynamicbeans.DynamicValueResolver;
import step.core.dynamicbeans.TestBean;
import step.core.dynamicbeans.TestBean2;
import step.expressions.ExpressionHandler;

public class DynamicValueSerializationTest {
    @Test
    public void testConstants() throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        TestBean bean = (TestBean)mapper.readValue("{\"testString\":{\"value\":\"test\"}, \"testBoolean\":{\"value\":true}, \"testInteger\":{\"value\":1}}", TestBean.class);
        Assert.assertEquals((Object)"test", (Object)bean.getTestString().get());
        Assert.assertEquals((Object)true, (Object)bean.getTestBoolean().get());
        Assert.assertEquals((long)1L, (long)((Integer)bean.getTestInteger().get()).intValue());
    }

    @Test
    public void testDynamic() throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        TestBean bean = (TestBean)mapper.readValue("{\"testString\":{\"dynamic\":true,\"expression\":\"'test'\"},\"testRecursive\":{\"value\":{\"testString\":{\"dynamic\":true,\"expression\":\"'test2'\"}}}}", TestBean.class);
        DynamicBeanResolver r = new DynamicBeanResolver(new DynamicValueResolver(new ExpressionHandler()));
        r.evaluate((Object)bean, null);
        Assert.assertEquals((Object)"test", (Object)bean.getTestString().get());
        Assert.assertEquals((Object)"test2", (Object)((TestBean2)bean.getTestRecursive().get()).getTestString().get());
    }
}

