/*
 * Decompiled with CFR 0.152.
 */
package step.core;

import ch.exense.commons.app.Configuration;
import step.core.GlobalContext;
import step.core.accessors.collections.CollectionRegistry;
import step.core.artefacts.reports.InMemoryReportNodeAccessor;
import step.core.artefacts.reports.ReportNodeAccessor;
import step.core.dynamicbeans.DynamicBeanResolver;
import step.core.dynamicbeans.DynamicValueResolver;
import step.core.execution.EventManager;
import step.core.execution.InMemoryExecutionAccessor;
import step.core.execution.model.ExecutionAccessor;
import step.core.plans.InMemoryPlanAccessor;
import step.core.plans.PlanAccessor;
import step.core.plugins.ControllerPluginManager;
import step.core.repositories.RepositoryObjectManager;
import step.core.scheduler.ExecutionTaskAccessor;
import step.core.scheduler.InMemoryExecutionTaskAccessor;
import step.expressions.ExpressionHandler;

public class GlobalContextBuilder {
    public static GlobalContext createGlobalContext() {
        GlobalContext context = new GlobalContext();
        context.setExpressionHandler(new ExpressionHandler());
        context.setDynamicBeanResolver(new DynamicBeanResolver(new DynamicValueResolver(context.getExpressionHandler())));
        Configuration configuration = new Configuration();
        ControllerPluginManager pluginManager = new ControllerPluginManager(configuration);
        context.setPluginManager(pluginManager);
        context.setConfiguration(configuration);
        context.put(CollectionRegistry.class, (Object)new CollectionRegistry());
        context.setExecutionAccessor((ExecutionAccessor)new InMemoryExecutionAccessor());
        context.setPlanAccessor((PlanAccessor)new InMemoryPlanAccessor());
        context.setReportAccessor((ReportNodeAccessor)new InMemoryReportNodeAccessor());
        context.setScheduleAccessor((ExecutionTaskAccessor)new InMemoryExecutionTaskAccessor());
        context.setRepositoryObjectManager(new RepositoryObjectManager(context.getPlanAccessor()));
        context.setEventManager(new EventManager());
        return context;
    }
}

