/*
 * Decompiled with CFR 0.152.
 */
package step.core.repositories;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.artefacts.CallPlan;
import step.artefacts.TestCase;
import step.artefacts.TestSet;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.ArtefactRegistry;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;
import step.core.execution.model.ReportExport;
import step.core.execution.model.ReportExportStatus;
import step.core.repositories.ArtefactInfo;
import step.core.repositories.ImportResult;
import step.core.repositories.Repository;
import step.core.repositories.RepositoryObjectReference;
import step.core.repositories.TestRunStatus;
import step.core.repositories.TestSetStatusOverview;

public class RepositoryObjectManager {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryObjectManager.class);
    public static final String CLIENT_KEY = "RepositoryObjectManager_Client";
    private Map<String, Repository> repositories = new ConcurrentHashMap<String, Repository>();
    private ArtefactAccessor artefactAccessor;
    private static final String LOCAL = "local";
    private static final String ARTEFACT_ID = "artefactid";

    public RepositoryObjectManager(ArtefactAccessor artefactAccessor) {
        this.artefactAccessor = artefactAccessor;
    }

    public void registerRepository(String id, Repository repository) {
        this.repositories.put(id, repository);
    }

    public ImportResult importArtefact(ExecutionContext context, RepositoryObjectReference artefact) throws Exception {
        String respositoryId = artefact.getRepositoryID();
        Repository repository = this.getRepository(respositoryId);
        return repository.importArtefact(context, artefact.getRepositoryParameters());
    }

    private Repository getRepository(String respositoryId) {
        Repository repository = this.repositories.get(respositoryId);
        if (repository == null) {
            throw new RuntimeException("Unknown repository '" + respositoryId + "'");
        }
        return repository;
    }

    public ReportExport exportTestExecutionReport(ExecutionContext context, RepositoryObjectReference report) {
        ReportExport export = new ReportExport();
        String respositoryId = report.getRepositoryID();
        if (!report.getRepositoryID().equals(LOCAL)) {
            Repository repository = this.getRepository(respositoryId);
            try {
                repository.exportExecution(context, report.getRepositoryParameters());
                export.setStatus(ReportExportStatus.SUCCESSFUL);
            }
            catch (Exception e) {
                export.setStatus(ReportExportStatus.FAILED);
                export.setError(e.getMessage() + ". See application logs for more details.");
                logger.error("Error while exporting test " + context.getExecutionId() + " to " + respositoryId, (Throwable)e);
            }
        }
        return export;
    }

    public ArtefactInfo getArtefactInfo(RepositoryObjectReference ref) throws Exception {
        try {
            if (ref.getRepositoryID().equals(LOCAL)) {
                String artefactid = (String)ref.getRepositoryParameters().get(ARTEFACT_ID);
                AbstractArtefact artefact = (AbstractArtefact)this.artefactAccessor.get(new ObjectId(artefactid));
                ArtefactInfo info = new ArtefactInfo();
                info.setName(artefact.getAttributes() != null ? (String)artefact.getAttributes().get("name") : null);
                info.setType(ArtefactRegistry.getArtefactName(artefact.getClass()));
                return info;
            }
            String respositoryId = ref.getRepositoryID();
            Repository repository = this.getRepository(respositoryId);
            return repository.getArtefactInfo(ref.getRepositoryParameters());
        }
        catch (Exception e) {
            logger.error("Error while getting artefact infos for " + ref, (Throwable)e);
            throw e;
        }
    }

    public TestSetStatusOverview getReport(RepositoryObjectReference report) throws Exception {
        if (!report.getRepositoryID().equals(LOCAL)) {
            String respositoryId = report.getRepositoryID();
            Repository repository = this.getRepository(respositoryId);
            return repository.getTestSetStatusOverview(report.getRepositoryParameters());
        }
        TestSetStatusOverview testSetStatusOverview = new TestSetStatusOverview();
        String artefactid = (String)report.getRepositoryParameters().get(ARTEFACT_ID);
        AbstractArtefact artefact = (AbstractArtefact)this.artefactAccessor.get(new ObjectId(artefactid));
        if (artefact instanceof TestSet) {
            Iterator children = this.artefactAccessor.getChildren(artefact);
            children.forEachRemaining(child -> {
                AbstractArtefact referencedArtefact;
                if (child instanceof TestCase) {
                    this.addTestRunStatus(testSetStatusOverview.getRuns(), (AbstractArtefact)child);
                } else if (child instanceof CallPlan && (referencedArtefact = this.artefactAccessor.get(((CallPlan)child).getArtefactId())) instanceof TestCase) {
                    this.addTestRunStatus(testSetStatusOverview.getRuns(), referencedArtefact);
                }
            });
        }
        return testSetStatusOverview;
    }

    private void addTestRunStatus(List<TestRunStatus> testRunStatusList, AbstractArtefact artefact) {
        testRunStatusList.add(new TestRunStatus((String)artefact.getAttributes().get("name"), ReportNodeStatus.NORUN));
    }
}

