/*
 * Decompiled with CFR 0.152.
 */
package step.core.export;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.deployment.JacksonMapperProvider;
import step.core.objectenricher.ObjectEnricher;

public class ImportManager {
    protected final ArtefactAccessor artefactAccessor;

    public ImportManager(ArtefactAccessor artefactAccessor) {
        this.artefactAccessor = artefactAccessor;
    }

    public void importArtefacts(File file, ObjectEnricher objectEnricher) throws IOException {
        ObjectMapper mapper = JacksonMapperProvider.createMapper();
        try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
            String line;
            while ((line = reader.readLine()) != null) {
                AbstractArtefact artefact = (AbstractArtefact)mapper.readValue(line, AbstractArtefact.class);
                objectEnricher.accept((Object)artefact);
                this.artefactAccessor.save((AbstractIdentifiableObject)artefact);
            }
        }
    }
}

