/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import java.util.HashMap;
import org.bson.types.ObjectId;
import step.core.GlobalContext;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.execution.ContextBuilder;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionManager;
import step.core.execution.ExecutionManagerImpl;
import step.core.execution.ExecutionRunnable;
import step.core.execution.ExecutionTypeListener;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionParameters;
import step.core.execution.model.ExecutionStatus;
import step.core.plugins.ExecutionCallbacks;
import step.core.scheduler.ExecutionTaskAccessor;
import step.core.scheduler.ExecutiontTaskParameters;
import step.threadpool.ThreadPool;

public class ExecutionRunnableFactory {
    private GlobalContext globalContext;
    private ExecutionTaskAccessor taskAccessor;
    private ArtefactAccessor artefactAccessor;

    public ExecutionRunnableFactory(GlobalContext globalContext) {
        this.globalContext = globalContext;
        this.taskAccessor = globalContext.getScheduleAccessor();
        this.artefactAccessor = globalContext.getArtefactAccessor();
    }

    public ExecutionRunnable newExecutionRunnable(Execution execution) {
        ExecutionContext context = this.createExecutionContext(execution);
        ExecutionRunnable task = new ExecutionRunnable(this.globalContext.getRepositoryObjectManager(), this.globalContext.getExecutionAccessor(), context);
        return task;
    }

    private ExecutionContext createExecutionContext(Execution execution) {
        ExecutionContext context;
        boolean isolatedContext = execution.getExecutionParameters().isIsolatedExecution();
        String executionId = execution.getId().toString();
        if (isolatedContext) {
            context = ContextBuilder.createLocalExecutionContext((String)executionId);
            context.setReportNodeAccessor(this.globalContext.getReportAccessor());
            context.setEventManager(this.globalContext.getEventManager());
            context.setExecutionCallbacks((ExecutionCallbacks)this.globalContext.getPluginManager().getProxy());
            ExecutionManagerImpl executionManager = new ExecutionManagerImpl(this.globalContext.getExecutionAccessor());
            context.put(ExecutionManager.class, (Object)executionManager);
        } else {
            context = new ExecutionContext(executionId);
            context.setExpressionHandler(this.globalContext.getExpressionHandler());
            context.setDynamicBeanResolver(this.globalContext.getDynamicBeanResolver());
            context.setConfiguration(this.globalContext.getConfiguration());
            context.setArtefactAccessor(this.globalContext.getArtefactAccessor());
            context.setReportNodeAccessor(this.globalContext.getReportAccessor());
            context.setEventManager(this.globalContext.getEventManager());
            context.setExecutionCallbacks((ExecutionCallbacks)this.globalContext.getPluginManager().getProxy());
            ExecutionManagerImpl executionManager = new ExecutionManagerImpl(this.globalContext.getExecutionAccessor());
            context.put(ExecutionManager.class, (Object)executionManager);
            context.setExecutionTypeListener((ExecutionTypeListener)executionManager);
            context.put(ThreadPool.class, (Object)new ThreadPool(context));
        }
        context.setExecutionParameters(execution.getExecutionParameters());
        context.updateStatus(ExecutionStatus.INITIALIZING);
        return context;
    }

    public Execution createExecution(ExecutionParameters executionParameters, String taskID) {
        Execution execution = new Execution();
        execution.setStartTime(Long.valueOf(System.currentTimeMillis()));
        execution.setExecutionParameters(executionParameters);
        execution.setStatus(ExecutionStatus.INITIALIZING);
        execution.setAttributes(new HashMap());
        if (executionParameters.getAttributes() != null) {
            execution.getAttributes().putAll(executionParameters.getAttributes());
        }
        if (taskID != null) {
            ExecutiontTaskParameters executiontTaskParameters = (ExecutiontTaskParameters)this.taskAccessor.get(new ObjectId(taskID));
            if (executiontTaskParameters != null && executiontTaskParameters.getAttributes() != null) {
                execution.getAttributes().putAll(executiontTaskParameters.getAttributes());
            }
            execution.setExecutionTaskID(taskID);
        }
        AbstractArtefact abstractArtefact = null;
        if (executionParameters.getArtefact() != null && executionParameters.getArtefact().getRepositoryParameters().containsKey("artefactid")) {
            abstractArtefact = this.artefactAccessor.get((String)executionParameters.getArtefact().getRepositoryParameters().get("artefactid"));
        }
        if (abstractArtefact != null && abstractArtefact.getAttributes() != null) {
            execution.getAttributes().putAll(abstractArtefact.getAttributes());
        }
        if (executionParameters.getDescription() != null) {
            execution.setDescription(executionParameters.getDescription());
        }
        this.globalContext.getExecutionAccessor().save((AbstractIdentifiableObject)execution);
        return execution;
    }
}

