/*
 * Decompiled with CFR 0.152.
 */
package step.core.deployment;

import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.access.Profile;
import step.core.deployment.AbstractServices;
import step.core.deployment.AccessServices;
import step.core.deployment.Secured;
import step.core.deployment.Session;
import step.core.deployment.TokenValidationException;

@Secured
@Provider
@Priority(value=1000)
public class AuthenticationFilter
extends AbstractServices
implements ContainerRequestFilter,
ClientResponseFilter {
    private static Logger logger = LoggerFactory.getLogger(AuthenticationFilter.class);
    @Inject
    private ExtendedUriInfo extendendUriInfo;
    @Inject
    private AccessServices accessServices;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        boolean useAuthentication = this.accessServices.useAuthentication();
        if (useAuthentication) {
            Cookie sessionCookie = (Cookie)requestContext.getCookies().get("sessionid");
            if (sessionCookie != null) {
                String token = sessionCookie.getValue();
                try {
                    Profile profile;
                    boolean hasRight;
                    Session session = this.validateToken(token);
                    requestContext.setProperty("session", (Object)session);
                    Secured annotation = this.extendendUriInfo.getMatchedResourceMethod().getInvocable().getHandlingMethod().getAnnotation(Secured.class);
                    String right = annotation.right();
                    if (right.length() > 0 && !(hasRight = (profile = session.getProfile()).getRights().contains(right))) {
                        requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
                    }
                }
                catch (TokenValidationException e) {
                    logger.debug("Incorrect session token or the token could not be validated.", (Throwable)e);
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                }
                catch (Exception e) {
                    logger.error("An exception was thrown while checking user rights.", (Throwable)e);
                    requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                }
            } else {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
        } else {
            requestContext.setProperty("session", (Object)AccessServices.ANONYMOUS_SESSION);
        }
    }

    private Session validateToken(String token) throws TokenValidationException {
        AccessServices authenticationService = (AccessServices)this.controller.getContext().get("AuthenticationService");
        if (authenticationService != null) {
            return authenticationService.validateAndTouchToken(token);
        }
        throw new TokenValidationException("authenticationService is null");
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
    }
}

