/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import javax.json.JsonObjectBuilder;
import javax.json.spi.JsonProvider;
import org.bson.types.ObjectId;
import org.jongo.MongoCollection;
import step.core.accessors.AbstractAccessor;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.CRUDAccessor;
import step.core.accessors.MongoClientSession;

public class AbstractCRUDAccessor<T extends AbstractIdentifiableObject>
extends AbstractAccessor
implements CRUDAccessor<T> {
    protected MongoCollection collection;
    private Class<T> entityClass;
    protected static JsonProvider jsonProvider = JsonProvider.provider();

    public AbstractCRUDAccessor(MongoClientSession clientSession, String collectionName, Class<T> entityClass) {
        super(clientSession);
        this.entityClass = entityClass;
        this.collection = this.getJongoCollection(collectionName);
    }

    public T get(ObjectId id) {
        AbstractIdentifiableObject entity = (AbstractIdentifiableObject)this.collection.findOne(id).as(this.entityClass);
        return (T)entity;
    }

    public T get(String id) {
        return this.get(new ObjectId(id));
    }

    public T findByAttributes(Map<String, String> attributes) {
        String query = this.queryByAttributes(attributes);
        return (T)((AbstractIdentifiableObject)this.collection.findOne(query).as(this.entityClass));
    }

    public Spliterator<T> findManyByAttributes(Map<String, String> attributes) {
        String query = this.queryByAttributes(attributes);
        return this.collection.find(query).as(this.entityClass).spliterator();
    }

    public T findByAttributes(Map<String, String> attributes, String attributesMapKey) {
        String query = this.queryByAttributes(attributes, attributesMapKey);
        return (T)((AbstractIdentifiableObject)this.collection.findOne(query).as(this.entityClass));
    }

    public Spliterator<T> findManyByAttributes(Map<String, String> attributes, String attributesMapKey) {
        String query = this.queryByAttributes(attributes, attributesMapKey);
        return this.collection.find(query).as(this.entityClass).spliterator();
    }

    protected String queryByAttributes(Map<String, String> attributes) {
        return this.queryByAttributes(attributes, "attributes");
    }

    protected String queryByAttributes(Map<String, String> attributes, String attributesMapKey) {
        JsonObjectBuilder builder = jsonProvider.createObjectBuilder();
        for (String key : attributes.keySet()) {
            builder.add(attributesMapKey + "." + key, attributes.get(key));
        }
        String query = builder.build().toString();
        return query;
    }

    public Iterator<T> getAll() {
        return this.collection.find().as(this.entityClass);
    }

    public void remove(ObjectId id) {
        this.collection.remove(id);
    }

    public T save(T entity) {
        this.collection.save(entity);
        return entity;
    }

    public void save(List<? extends T> entities) {
        this.collection.insert(entities.toArray());
    }
}

