/*
 * Decompiled with CFR 0.152.
 */
package step.core.artefacts.reports;

import org.junit.Assert;
import org.junit.Test;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportTreeAccessor;
import step.core.artefacts.reports.ReportTreeVisitor;
import step.core.plans.Plan;
import step.core.plans.builder.PlanBuilder;
import step.core.plans.builder.PlanBuilderTest;
import step.core.plans.runner.DefaultPlanRunner;
import step.core.plans.runner.PlanRunnerResult;

public class ReportTreeVisitorTest {
    @Test
    public void testGetRootReportNode() {
        Plan plan = this.getDummyPlan();
        DefaultPlanRunner runner = new DefaultPlanRunner();
        PlanRunnerResult result = runner.run(plan);
        ReportTreeAccessor treeAccessor = result.getReportTreeAccessor();
        ReportTreeVisitor v = new ReportTreeVisitor(treeAccessor);
        ReportNode root = v.getRootReportNode(result.getExecutionId());
        junit.framework.Assert.assertNotNull((Object)root);
        junit.framework.Assert.assertEquals((String)"Root", (String)root.getArtefactInstance().getDescription());
    }

    @Test
    public void test() {
        Plan plan = this.getDummyPlan();
        DefaultPlanRunner runner = new DefaultPlanRunner();
        PlanRunnerResult result = runner.run(plan);
        ReportTreeAccessor treeAccessor = result.getReportTreeAccessor();
        ReportTreeVisitor v = new ReportTreeVisitor(treeAccessor);
        v.visit(result.getExecutionId(), e -> {
            ReportNode node = e.getNode();
            if (node.getArtefactInstance().getDescription().equals("Root")) {
                Assert.assertNull((Object)e.getParentNode());
                Assert.assertEquals((long)0L, (long)e.getStack().size());
            } else if (node.getArtefactInstance().getDescription().equals("Node1")) {
                Assert.assertEquals((Object)"Root", (Object)e.getParentNode().getArtefactInstance().getDescription());
                Assert.assertEquals((long)1L, (long)e.getStack().size());
            } else if (node.getArtefactInstance().getDescription().equals("Node2")) {
                Assert.assertEquals((Object)"Root", (Object)e.getParentNode().getArtefactInstance().getDescription());
                Assert.assertEquals((long)1L, (long)e.getStack().size());
            } else if (node.getArtefactInstance().getDescription().equals("Node2.1")) {
                Assert.assertEquals((Object)"Node2", (Object)e.getParentNode().getArtefactInstance().getDescription());
                Assert.assertEquals((long)2L, (long)e.getStack().size());
                Assert.assertEquals((Object)"Root", (Object)e.getRootNode().getArtefactInstance().getDescription());
            } else {
                throw new RuntimeException("Unexpected node " + node.getName());
            }
        });
    }

    protected Plan getDummyPlan() {
        Plan plan = PlanBuilder.create().startBlock(PlanBuilderTest.artefact("Root")).add(PlanBuilderTest.artefact("Node1")).startBlock(PlanBuilderTest.artefact("Node2")).add(PlanBuilderTest.artefact("Node2.1")).endBlock().endBlock().build();
        return plan;
    }
}

