/*
 * Decompiled with CFR 0.152.
 */
package step.core.export;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.artefacts.ArtefactAccessor;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.export.ExportManager;
import step.core.export.ExportTaskManager;
import step.resources.Resource;
import step.resources.ResourceRevisionContainer;

@Singleton
@Path(value="export")
public class ExportServices
extends AbstractServices {
    private static final Logger logger = LoggerFactory.getLogger(ExportServices.class);
    ExportManager exportManager;
    ExportTaskManager exportTaskManager;

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
        ArtefactAccessor accessor = this.getContext().getArtefactAccessor();
        this.exportTaskManager = (ExportTaskManager)this.getContext().get(ExportTaskManager.class);
        this.exportManager = new ExportManager(accessor);
    }

    @GET
    @Path(value="/artefact/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-read")
    public ExportTaskManager.ExportStatus exportArtefact(final @PathParam(value="id") String id) {
        return this.exportTaskManager.createExportTask(new ExportTaskManager.ExportRunnable(){

            @Override
            public Resource runExport() throws IOException {
                ResourceRevisionContainer resourceContainer = this.getResourceManager().createResourceContainer("temp", "artefact_export.json");
                ExportServices.this.exportManager.exportArtefactWithChildren(id, resourceContainer.getOutputStream());
                resourceContainer.save(null);
                return resourceContainer.getResource();
            }
        });
    }

    @GET
    @Path(value="/artefacts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-read")
    public ExportTaskManager.ExportStatus exportAllArtefacts() {
        return this.exportTaskManager.createExportTask(new ExportTaskManager.ExportRunnable(){

            @Override
            public Resource runExport() throws FileNotFoundException, IOException {
                ResourceRevisionContainer resourceContainer = this.getResourceManager().createResourceContainer("temp", "artefact_export.json");
                ExportServices.this.exportManager.exportAllArtefacts(resourceContainer.getOutputStream());
                resourceContainer.save(null);
                return resourceContainer.getResource();
            }
        });
    }

    @GET
    @Path(value="/{id}/status")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ExportTaskManager.ExportStatus getExportStatus(@PathParam(value="id") String id) {
        return this.exportTaskManager.getExportStatus(id);
    }
}

