/*
 * Decompiled with CFR 0.152.
 */
package step.core.deployment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bson.Document;
import org.bson.conversions.Bson;
import step.core.GlobalContext;
import step.core.deployment.Session;

public class FragmentSupplier {
    private List<String> excludedContexts;
    private List<Function<Session, Map<String, String>>> additionalQueryFragmentSuppliers = new ArrayList<Function<Session, Map<String, String>>>();

    public FragmentSupplier(GlobalContext context) {
        String[] split;
        String excludedContextsValue = context.getConfiguration().getProperty("plugins.MultitenancyPlugin.excludedContexts", "");
        if (excludedContextsValue != null && (split = excludedContextsValue.split(",")).length > 0) {
            this.excludedContexts = Arrays.asList(split);
        }
    }

    public List<Function<Session, Map<String, String>>> getAdditionalQueryFragmentSuppliers() {
        return this.additionalQueryFragmentSuppliers;
    }

    private List<Bson> toBson(Map<String, String> additionalQueryFragmentSuppliers) {
        ArrayList<Bson> bson = new ArrayList<Bson>();
        for (Map.Entry<String, String> e : additionalQueryFragmentSuppliers.entrySet()) {
            bson.add((Bson)new Document("attributes." + e.getKey(), (Object)e.getValue()));
        }
        return bson;
    }

    public boolean add(Function<Session, Map<String, String>> e) {
        return this.additionalQueryFragmentSuppliers.add(e);
    }

    public Map<String, String> getAdditionalQueryFragmentsFromContextAsAttributes(Session session, String collectionID, String ignoreContext) {
        return this.computeFragments(session, collectionID, ignoreContext);
    }

    public List<Bson> getAdditionalQueryFragmentsFromContextAsBson(Session session, String collectionID, String ignoreContext) {
        return this.toBson(this.computeFragments(session, collectionID, ignoreContext));
    }

    private Map<String, String> computeFragments(Session session, String collectionID, String ignoreContext) {
        HashMap<String, String> additionalQueryFragments = new HashMap<String, String>();
        if (!(this.excludedContexts.contains(collectionID) || ignoreContext != null && ignoreContext.equals("true"))) {
            this.getAdditionalQueryFragmentSuppliers().forEach(s -> additionalQueryFragments.putAll((Map)s.apply(session)));
        }
        return additionalQueryFragments;
    }
}

