/*
 * Decompiled with CFR 0.152.
 */
package step.core.deployment;

import ch.exense.commons.app.Configuration;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.access.AccessConfiguration;
import step.core.access.AccessManager;
import step.core.access.Authenticator;
import step.core.access.Credentials;
import step.core.access.DefaultAccessManager;
import step.core.access.DefaultAuthenticator;
import step.core.access.Profile;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.deployment.Session;
import step.core.deployment.TokenValidationException;

@Singleton
@Path(value="/access")
public class AccessServices
extends AbstractServices {
    private static Logger logger = LoggerFactory.getLogger(AccessServices.class);
    public static final String AUTHENTICATION_SERVICE = "AuthenticationService";
    private ConcurrentHashMap<String, Session> sessions;
    private Timer sessionExpirationTimer;
    private Authenticator authenticator;
    private AccessManager accessManager;
    static Session ANONYMOUS_SESSION = new Session();

    public AccessServices() {
        String username = "admin";
        ANONYMOUS_SESSION.setUsername(username);
        Profile profile = new Profile();
        profile.setRole("default");
        profile.setRights(DefaultAccessManager.defaultRights);
        ANONYMOUS_SESSION.setProfile(profile);
        this.sessions = new ConcurrentHashMap();
    }

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
        this.controller.getContext().put(AUTHENTICATION_SERVICE, this);
        this.configuration = this.controller.getContext().getConfiguration();
        this.initAuthenticator();
        this.initAccessManager();
        this.sessionExpirationTimer = new Timer("Session expiration timer");
        this.sessionExpirationTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                int sessionTimeout = AccessServices.this.configuration.getPropertyAsInteger("ui.sessiontimeout.minutes", Integer.valueOf(180)) * 60000;
                long time = System.currentTimeMillis();
                AccessServices.this.sessions.entrySet().removeIf(entry -> ((Session)((Object)((Object)entry.getValue()))).lasttouch + (long)sessionTimeout < time);
            }
        }, 60000L, 60000L);
    }

    @PreDestroy
    private void close() {
        if (this.sessionExpirationTimer != null) {
            this.sessionExpirationTimer.cancel();
        }
    }

    private void initAuthenticator() throws Exception {
        String authenticatorClass = this.configuration.getProperty("ui.authenticator", null);
        if (authenticatorClass == null) {
            this.authenticator = new DefaultAuthenticator();
        } else {
            try {
                this.authenticator = (Authenticator)this.getClass().getClassLoader().loadClass(authenticatorClass).newInstance();
            }
            catch (Exception e) {
                logger.error("Error while initializing authenticator '" + authenticatorClass + "'", (Throwable)e);
                throw e;
            }
        }
        this.authenticator.init(this.getContext());
    }

    private void initAccessManager() throws Exception {
        String accessManagerClass = this.configuration.getProperty("ui.accessmanager", null);
        if (accessManagerClass == null) {
            this.accessManager = new DefaultAccessManager();
        } else {
            try {
                this.accessManager = (AccessManager)this.getClass().getClassLoader().loadClass(accessManagerClass).newInstance();
            }
            catch (Exception e) {
                logger.error("Error while initializing access manager '" + accessManagerClass + "'", (Throwable)e);
                throw e;
            }
        }
        this.accessManager.init(this.getContext());
    }

    @POST
    @Path(value="/login")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response authenticateUser(Credentials credentials) {
        boolean authenticated = this.authenticator.authenticate(credentials);
        if (authenticated) {
            Session session = this.issueToken(credentials.getUsername());
            NewCookie cookie = new NewCookie("sessionid", session.getToken(), "/", null, 1, null, -1, null, false, false);
            Profile profile = this.getProfile(credentials.getUsername());
            session.setProfile(profile);
            return Response.ok((Object)((Object)session)).cookie(new NewCookie[]{cookie}).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @POST
    @Secured
    @Path(value="/logout")
    public void logout(@Context ContainerRequestContext crc) {
        Session session = (Session)((Object)crc.getProperty("session"));
        if (session != null) {
            this.sessions.remove(session.getToken());
        }
    }

    @GET
    @Path(value="/conf")
    public AccessConfiguration getAccessConfiguration() {
        AccessConfiguration conf = new AccessConfiguration();
        conf.setDemo(this.isDemo());
        conf.setAuthentication(this.useAuthentication());
        conf.setRoles(this.accessManager.getRoles());
        Configuration ctrlConf = this.getContext().getConfiguration();
        conf.getMiscParams().put("enforceschemas", this.getContext().getConfiguration().getProperty("enforceschemas", "false"));
        if (ctrlConf.hasProperty("ui.default.url")) {
            conf.setDefaultUrl(ctrlConf.getProperty("ui.default.url"));
        }
        return conf;
    }

    public boolean useAuthentication() {
        return this.configuration.getPropertyAsBoolean("authentication", true);
    }

    public boolean isDemo() {
        return this.configuration.getPropertyAsBoolean("demo", false);
    }

    @Override
    @GET
    @Secured
    @Path(value="/session")
    public Session getSession(@Context ContainerRequestContext crc) {
        boolean useAuthentication = this.configuration.getPropertyAsBoolean("authentication", true);
        if (useAuthentication) {
            Session session = (Session)((Object)crc.getProperty("session"));
            return session;
        }
        return ANONYMOUS_SESSION;
    }

    @GET
    @Path(value="/checkToken")
    public Boolean isValidToken(@QueryParam(value="token") String token) {
        boolean useAuthentication = this.configuration.getPropertyAsBoolean("authentication", true);
        if (useAuthentication) {
            try {
                this.validateAndTouchToken(token);
            }
            catch (TokenValidationException e) {
                logger.debug("Token " + token + " is invalid.");
                return false;
            }
            logger.debug("Token " + token + " is valid.");
            return true;
        }
        return true;
    }

    private Profile getProfile(String username) {
        Profile profile = new Profile();
        List<String> rights = this.accessManager.getRights(username);
        profile.setRights(rights);
        profile.setRole(this.accessManager.getRole(username));
        return profile;
    }

    private Session issueToken(String username) {
        String token = UUID.randomUUID().toString();
        Session session = new Session();
        session.setToken(token);
        session.setUsername(username);
        this.sessions.put(token, session);
        return session;
    }

    public Session validateAndTouchToken(String token) throws TokenValidationException {
        Session session = this.sessions.get(token);
        if (session == null) {
            throw new TokenValidationException("Session with token '" + token + "' is invalid");
        }
        session.touch();
        return session;
    }
}

