/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import java.util.HashMap;
import java.util.Map;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionManager;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionAccessor;
import step.core.execution.model.ExecutionStatus;
import step.core.repositories.ImportResult;

public class ExecutionManagerImpl
implements ExecutionManager {
    private final ExecutionAccessor accessor;

    public ExecutionManagerImpl(ExecutionAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void updateParameters(ExecutionContext context) {
        Execution execution = this.getExecution(context);
        execution.setResult(ReportNodeStatus.RUNNING);
        HashMap params = new HashMap();
        for (Map.Entry entry : context.getVariablesManager().getAllVariables().entrySet()) {
            params.put(entry.getKey(), entry.getValue().toString());
        }
        execution.setParameters(params);
        this.saveExecution(execution);
    }

    @Override
    public void persistStatus(ExecutionContext context) {
        Execution execution = this.getExecution(context);
        if (context.getStatus() == ExecutionStatus.ENDED) {
            execution.setEndTime(System.currentTimeMillis());
        }
        execution.setStatus(context.getStatus());
        if (context.getArtefact() != null) {
            execution.setArtefactID(context.getArtefact().getId().toString());
            if (execution.getDescription() == null) {
                AbstractArtefact artefact = context.getArtefact();
                execution.setDescription(artefact.getAttributes() != null ? (String)artefact.getAttributes().get("name") : null);
            }
        }
        this.saveExecution(execution);
    }

    @Override
    public void persistImportResult(ExecutionContext context, ImportResult importResult) {
        Execution execution = this.getExecution(context);
        execution.setImportResult(importResult);
        this.saveExecution(execution);
    }

    @Override
    public void updateStatus(ExecutionContext context, ExecutionStatus status) {
        context.updateStatus(status);
        this.persistStatus(context);
    }

    private void saveExecution(Execution execution) {
        this.accessor.save((AbstractIdentifiableObject)execution);
    }

    private Execution getExecution(ExecutionContext context) {
        Execution execution = this.accessor.get(context.getExecutionId());
        return execution;
    }

    @Override
    public void updateExecutionType(ExecutionContext context, String newType) {
        Execution execution = this.getExecution(context);
        execution.setExecutionType(newType);
        this.saveExecution(execution);
    }

    @Override
    public void updateExecutionResult(ExecutionContext context, ReportNodeStatus resultStatus) {
        Execution execution = this.getExecution(context);
        execution.setResult(resultStatus);
        this.saveExecution(execution);
    }
}

