/*
 * Decompiled with CFR 0.152.
 */
package step.core.deployment;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.bson.types.ObjectId;
import step.commons.datatable.DataTable;
import step.commons.datatable.TableRow;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.ArtefactRegistry;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.deployment.AbstractServices;
import step.core.deployment.FindByCriteraParam;
import step.core.deployment.MoveArtefactData;
import step.core.deployment.Secured;
import step.core.deployment.Session;
import step.core.execution.ExecutionRunnable;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionAccessorImpl;
import step.core.execution.model.ExecutionParameters;
import step.core.execution.model.ExecutionStatus;
import step.core.repositories.ArtefactInfo;
import step.core.repositories.RepositoryObjectReference;
import step.core.repositories.TestSetStatusOverview;
import step.core.scheduler.ExecutiontTaskParameters;

@Singleton
@Path(value="controller")
public class ControllerServices
extends AbstractServices {
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/shutdown")
    @Secured(right="admin")
    public void shutdown() {
        new Thread(){

            @Override
            public void run() {
                ControllerServices.this.controller.destroy();
            }
        }.start();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/task")
    @Secured(right="task-write")
    public void schedule(ExecutiontTaskParameters schedule) {
        this.getScheduler().addExecutionTask(schedule);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/task/{id}/execute")
    @Secured(right="plan-execute")
    public String execute(@PathParam(value="id") String executionTaskID, @Context ContainerRequestContext crc) {
        Session session = (Session)((Object)crc.getProperty("session"));
        if (session != null) {
            return this.getScheduler().executeExecutionTask(executionTaskID, session.username);
        }
        throw new RuntimeException("Invalid session");
    }

    @PUT
    @Path(value="/task/{id}")
    @Secured(right="task-write")
    public void enableExecutionTask(@PathParam(value="id") String executionTaskID) {
        this.getScheduler().enableExecutionTask(executionTaskID);
    }

    @DELETE
    @Path(value="/task/{id}")
    @Secured(right="task-delete")
    public void removeExecutionTask(@PathParam(value="id") String executionTaskID, @QueryParam(value="remove") Boolean remove) {
        if (remove != null && remove.booleanValue()) {
            this.getScheduler().removeExecutionTask(executionTaskID);
        } else {
            this.getScheduler().disableExecutionTask(executionTaskID);
        }
    }

    @GET
    @Path(value="/task/{id}")
    @Produces(value={"application/json"})
    @Secured(right="task-read")
    public ExecutiontTaskParameters getExecutionTask(@PathParam(value="id") String executionTaskID) {
        return this.getScheduler().get(executionTaskID);
    }

    @GET
    @Path(value="/task")
    @Produces(value={"application/json"})
    @Secured(right="task-read")
    public List<ExecutiontTaskParameters> getScheduledExecutions() {
        ArrayList<ExecutiontTaskParameters> result = new ArrayList<ExecutiontTaskParameters>();
        Iterator<ExecutiontTaskParameters> it = this.getScheduler().getActiveAndInactiveExecutionTasks();
        int maxSize = 50;
        while (it.hasNext() && result.size() < maxSize) {
            result.add(it.next());
        }
        return result;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/executions/findByCritera")
    @Secured(right="execution-write")
    public List<Execution> findByCritera(FindByCriteraParam param) {
        return ((ExecutionAccessorImpl)this.getContext().getExecutionAccessor()).findByCritera(param.getCriteria(), param.getStart().getTime(), param.getEnd().getTime(), param.getSkip(), param.getLimit());
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/execution")
    @Secured(right="plan-execute")
    public String execute(ExecutionParameters executionParams) {
        String executionID = this.getScheduler().execute(executionParams);
        return executionID;
    }

    @GET
    @Path(value="/execution/{id}")
    @Produces(value={"application/json"})
    @Secured(right="report-read")
    public Execution getExecution(@PathParam(value="id") String executionID) {
        return this.getContext().getExecutionAccessor().get(executionID);
    }

    @GET
    @Path(value="/execution/{id}/rtmlink")
    @Produces(value={"application/json"})
    @Secured(right="report-read")
    public RTMLink getRtmLink(@PathParam(value="id") String executionID) {
        RTMLink link = new RTMLink();
        return link;
    }

    @POST
    @Path(value="/executions/byref")
    @Produces(value={"application/json"})
    @Secured(right="report-read")
    public List<Execution> getExecutionsByRepositoryObjectReference(RepositoryObjectReference objectReference) {
        List executionsByArtefactURL = this.getContext().getExecutionAccessor().getTestExecutionsByArtefactURL(objectReference);
        return executionsByArtefactURL;
    }

    @GET
    @Path(value="/execution/{id}/statusdistribution")
    @Produces(value={"application/json"})
    @Secured(right="report-read")
    public Map<ReportNodeStatus, Integer> getStatusReport(@PathParam(value="id") String executionID, @QueryParam(value="class") String reportNodeClass) {
        return this.getContext().getReportAccessor().getLeafReportNodesStatusDistribution(executionID, reportNodeClass);
    }

    @GET
    @Path(value="/execution/{id}/throughput")
    @Produces(value={"application/json;response-pass-through=true"})
    @Secured(right="report-read")
    public DataTable getStatusReport(@PathParam(value="id") String executionID, @QueryParam(value="resolution") Integer nInterval) {
        Execution e = this.getContext().getExecutionAccessor().get(executionID);
        long t2 = e.getStatus() == ExecutionStatus.ENDED ? e.getEndTime() : System.currentTimeMillis();
        long duration = t2 - e.getStartTime();
        int resolution = (int)(1.0 * (double)duration / (double)nInterval.intValue());
        DataTable t = this.getContext().getReportAccessor().getTimeBasedReport(executionID, resolution);
        if (t.getRows().size() < resolution) {
            long time = t.getRows().size() > 0 ? ((TableRow)t.getRows().get(t.getRows().size() - 1)).getDate().getTime() : e.getStartTime();
            for (int i = t.getRows().size(); i < nInterval; ++i) {
                t.addRow(new TableRow(new Date(time += (long)resolution), Double.valueOf(0.0)));
            }
        }
        return t;
    }

    @GET
    @Path(value="/execution/{id}/reportnodes")
    @Produces(value={"application/json"})
    @Secured(right="report-read")
    public List<ReportNode> getReportNodesByExecutionID(@PathParam(value="id") String executionID, @QueryParam(value="class") String reportNodeClass, @QueryParam(value="limit") int limit) {
        ArrayList<ReportNode> result = new ArrayList<ReportNode>();
        Iterator iterator = reportNodeClass != null ? this.getContext().getReportAccessor().getReportNodesByExecutionIDAndClass(executionID, reportNodeClass) : this.getContext().getReportAccessor().getReportNodesByExecutionID(executionID);
        for (int i = 0; iterator.hasNext() && i < limit; ++i) {
            result.add((ReportNode)iterator.next());
        }
        return result;
    }

    @GET
    @Path(value="/execution/{id}/stop")
    @Secured(right="plan-execute")
    public Void abort(@PathParam(value="id") String executionID) {
        ExecutionRunnable task = this.getExecutionRunnable(executionID);
        if (task != null) {
            task.getExecutionLifecycleManager().abort();
        }
        return null;
    }

    @GET
    @Path(value="/reportnode/{id}")
    @Produces(value={"application/json"})
    @Secured(right="report-read")
    public ReportNode getReportNode(@PathParam(value="id") String reportNodeId) {
        return (ReportNode)this.getContext().getReportAccessor().get(new ObjectId(reportNodeId));
    }

    @GET
    @Path(value="/reportnode/{id}/path")
    @Secured(right="report-read")
    public List<ReportNodeAndArtefact> getReportNodePath(@PathParam(value="id") String reportNodeId) {
        ArrayList<ReportNodeAndArtefact> result = new ArrayList<ReportNodeAndArtefact>();
        ArtefactAccessor artefactAccessor = this.getContext().getArtefactAccessor();
        List path = this.getContext().getReportAccessor().getReportNodePath(new ObjectId(reportNodeId));
        path.forEach(node -> result.add(new ReportNodeAndArtefact((ReportNode)node, node.getArtefactID() != null ? (AbstractArtefact)artefactAccessor.get(node.getArtefactID()) : null)));
        return result;
    }

    @GET
    @Path(value="/reportnode/{id}/children")
    @Produces(value={"application/json"})
    @Secured(right="report-read")
    public List<ReportNode> getReportNodeChildren(@PathParam(value="id") String reportNodeId, @QueryParam(value="skip") Integer skip, @QueryParam(value="limit") Integer limit) {
        skip = skip != null ? skip : 0;
        limit = limit != null ? limit : 1000;
        ArrayList<ReportNode> result = new ArrayList<ReportNode>();
        Iterator it = this.getContext().getReportAccessor().getChildren(new ObjectId(reportNodeId), skip.intValue(), limit.intValue());
        while (it.hasNext()) {
            result.add((ReportNode)it.next());
        }
        return result;
    }

    @GET
    @Path(value="/executions")
    @Produces(value={"application/json"})
    @Secured(right="report-read")
    public List<Execution> getExecutions(@QueryParam(value="limit") int limit) {
        ArrayList<Execution> result = new ArrayList<Execution>();
        for (Execution e : this.getContext().getExecutionAccessor().findLastStarted(limit)) {
            result.add(e);
        }
        return result;
    }

    @POST
    @Path(value="/repository/artefact/info")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="report-read")
    public ArtefactInfo getArtefactInfo(RepositoryObjectReference ref) {
        try {
            return this.getContext().getRepositoryObjectManager().getArtefactInfo(ref);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((int)500).entity((Object)("Unable to retrieve artefact." + e.getMessage())).type("text/plain").build());
        }
    }

    @POST
    @Path(value="/repository/report")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="report-read")
    public TestSetStatusOverview getReport(RepositoryObjectReference report) throws Exception {
        return this.getContext().getRepositoryObjectManager().getReport(report);
    }

    @GET
    @Path(value="/artefact/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-read")
    public AbstractArtefact getArtefact(@PathParam(value="id") String id) {
        return (AbstractArtefact)this.getContext().getArtefactAccessor().get(new ObjectId(id));
    }

    @POST
    @Path(value="/artefact/search")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-read")
    public AbstractArtefact searchArtefactByAttributes(Map<String, String> attributes) {
        return this.getContext().getArtefactAccessor().findByAttributes(attributes);
    }

    @POST
    @Path(value="/artefact/{id}/attributes")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public AbstractArtefact saveArtefactAttributes(Map<String, String> attributes, @PathParam(value="id") String id) {
        ArtefactAccessor accessor = this.getContext().getArtefactAccessor();
        AbstractArtefact artefact = accessor.get(id);
        artefact.setAttributes(attributes);
        return (AbstractArtefact)accessor.save((AbstractIdentifiableObject)artefact);
    }

    @POST
    @Path(value="/artefact")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public AbstractArtefact saveArtefact(AbstractArtefact artefact) {
        return (AbstractArtefact)this.getContext().getArtefactAccessor().save((AbstractIdentifiableObject)artefact);
    }

    @POST
    @Path(value="/artefacts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public void saveArtefact(List<AbstractArtefact> artefact) {
        this.getContext().getArtefactAccessor().save(artefact);
    }

    @GET
    @Path(value="/artefact/{id}/descendants")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-read")
    public ArtefactTree getArtefactDescendants(@PathParam(value="id") String id) {
        ArtefactAccessor a = this.getContext().getArtefactAccessor();
        AbstractArtefact root = a.get(id);
        ArtefactTree rootNode = new ArtefactTree(root);
        this.getChildrenRecursive(a, rootNode);
        return rootNode;
    }

    @GET
    @Path(value="/artefact/types")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-read")
    public Set<String> getArtefactTypes() {
        return ArtefactRegistry.getInstance().getArtefactNames();
    }

    @GET
    @Path(value="/artefact/types/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-read")
    public AbstractArtefact getArtefactType(@PathParam(value="id") String type) throws Exception {
        Class clazz = ArtefactRegistry.getInstance().getArtefactType(type);
        AbstractArtefact sample = (AbstractArtefact)clazz.newInstance();
        for (Method m : clazz.getMethods()) {
            if (m.getAnnotation(PostConstruct.class) == null) continue;
            m.invoke((Object)sample, new Object[0]);
        }
        this.getContext().getArtefactAccessor().save((AbstractIdentifiableObject)sample);
        return sample;
    }

    private void getChildrenRecursive(ArtefactAccessor a, ArtefactTree current) {
        AbstractArtefact parent = current.getArtefact();
        if (parent.getChildrenIDs() != null) {
            ArrayList<ArtefactTree> childrenNodes = new ArrayList<ArtefactTree>();
            for (ObjectId childId : parent.getChildrenIDs()) {
                AbstractArtefact child = (AbstractArtefact)a.get(childId);
                ArtefactTree childNode = new ArtefactTree(child);
                childrenNodes.add(childNode);
                this.getChildrenRecursive(a, childNode);
            }
            current.setChildren(childrenNodes);
        }
    }

    @POST
    @Path(value="/artefact/{id}/children")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public AbstractArtefact addChild(@PathParam(value="id") String id, AbstractArtefact child) {
        ArtefactAccessor a = this.getContext().getArtefactAccessor();
        child = (AbstractArtefact)a.save((AbstractIdentifiableObject)child);
        AbstractArtefact artefact = a.get(id);
        artefact.addChild(child.getId());
        a.save((AbstractIdentifiableObject)artefact);
        return child;
    }

    @DELETE
    @Path(value="/artefact/{id}/children/{childid}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public void removeChild(@PathParam(value="id") String parentid, @PathParam(value="childid") String childid) {
        ArtefactAccessor a = this.getContext().getArtefactAccessor();
        AbstractArtefact artefact = a.get(parentid);
        artefact.removeChild(new ObjectId(childid));
        a.save((AbstractIdentifiableObject)artefact);
    }

    @POST
    @Path(value="/artefact/{id}/children/{childid}/move")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public void moveChildUp(@PathParam(value="id") String parentid, @PathParam(value="childid") String childid, int offset) {
        ObjectId child;
        ArtefactAccessor a = this.getContext().getArtefactAccessor();
        AbstractArtefact artefact = a.get(parentid);
        int pos = artefact.indexOf(child = new ObjectId(childid));
        int newPos = pos + offset;
        if (newPos >= 0 && newPos < artefact.getChildrenIDs().size()) {
            artefact.removeChild(child);
            artefact.add(newPos, child);
        }
        a.save((AbstractIdentifiableObject)artefact);
    }

    @POST
    @Path(value="/artefact/{id}/move")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public void moveArtefact(@PathParam(value="id") String id, @QueryParam(value="from") String originParentId, @QueryParam(value="to") String targetParentId, @QueryParam(value="pos") int newPosition) {
        ArtefactAccessor a = this.getContext().getArtefactAccessor();
        AbstractArtefact origin = a.get(originParentId);
        origin.removeChild(new ObjectId(id));
        a.save((AbstractIdentifiableObject)origin);
        AbstractArtefact target = a.get(targetParentId);
        target.add(newPosition, new ObjectId(id));
        a.save((AbstractIdentifiableObject)target);
    }

    @POST
    @Path(value="/artefacts/move")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public void moveArtefacts(List<MoveArtefactData> nodes) {
        ArtefactAccessor a = this.getContext().getArtefactAccessor();
        for (MoveArtefactData node : nodes) {
            AbstractArtefact origin = a.get(node.getOldParent());
            origin.removeChild(new ObjectId(node.getId()));
            a.save((AbstractIdentifiableObject)origin);
            AbstractArtefact target = a.get(node.getParent());
            target.add(node.getPosition(), new ObjectId(node.getId()));
            a.save((AbstractIdentifiableObject)target);
        }
    }

    @POST
    @Path(value="/artefact/{id}/copy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public ObjectId copyArtefact(@PathParam(value="id") String id, @QueryParam(value="to") String targetParentId, @QueryParam(value="pos") int newPosition, @QueryParam(value="name") String name) {
        AbstractArtefact target = this.getContext().getArtefactManager().copyArtefact(id, targetParentId, name);
        return target.getId();
    }

    @POST
    @Path(value="/artefact/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="plan-write")
    public void updateArtefact(AbstractArtefact artefact) {
        this.getContext().getArtefactAccessor().save((AbstractIdentifiableObject)artefact);
    }

    @DELETE
    @Path(value="/artefact/{id}")
    @Consumes(value={"application/json"})
    @Secured(right="plan-delete")
    public void deleteArtefact(@PathParam(value="id") String id) {
        this.getContext().getArtefactManager().removeRecursive(new ObjectId(id));
    }

    public class ArtefactTree {
        AbstractArtefact artefact;
        List<ArtefactTree> children;

        public ArtefactTree(AbstractArtefact artefact) {
            this.artefact = artefact;
        }

        public AbstractArtefact getArtefact() {
            return this.artefact;
        }

        public List<ArtefactTree> getChildren() {
            return this.children;
        }

        public void setChildren(List<ArtefactTree> children) {
            this.children = children;
        }
    }

    class ReportNodeAndArtefact {
        ReportNode reportNode;
        AbstractArtefact artefact;

        public ReportNodeAndArtefact() {
        }

        public ReportNodeAndArtefact(ReportNode reportNode, AbstractArtefact artefact) {
            this.reportNode = reportNode;
            this.artefact = artefact;
        }

        public ReportNode getReportNode() {
            return this.reportNode;
        }

        public void setReportNode(ReportNode reportNode) {
            this.reportNode = reportNode;
        }

        public AbstractArtefact getArtefact() {
            return this.artefact;
        }

        public void setArtefact(AbstractArtefact artefact) {
            this.artefact = artefact;
        }
    }

    public class RTMLink {
        String link;

        public String getLink() {
            return this.link;
        }
    }
}

