/*
 * Decompiled with CFR 0.152.
 */
package step.core.export;

import ch.exense.commons.io.Poller;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.junit.Test;
import step.core.export.ExportTaskManager;
import step.resources.Resource;

public class ExportTaskManagerTest {
    @Test
    public void test() throws InterruptedException, TimeoutException {
        ExportTaskManager m = new ExportTaskManager(null);
        final AtomicInteger i = new AtomicInteger(0);
        ExportTaskManager.ExportStatus s = m.createExportTask(new ExportTaskManager.ExportRunnable(){

            protected Resource runExport() throws Exception {
                i.incrementAndGet();
                Resource resource = new Resource();
                return resource;
            }
        });
        Poller.waitFor(() -> m.getExportStatus((String)s.getId()).ready, (long)2000L);
        Assert.assertEquals((int)0, (int)m.exportStatusMap.size());
        Assert.assertEquals((int)1, (int)i.get());
    }

    @Test
    public void testException() throws InterruptedException, TimeoutException {
        ExportTaskManager m = new ExportTaskManager(null);
        ExportTaskManager.ExportStatus s = m.createExportTask(new ExportTaskManager.ExportRunnable(){

            protected Resource runExport() throws Exception {
                throw new RuntimeException();
            }
        });
        Poller.waitFor(() -> m.getExportStatus((String)s.getId()).ready, (long)2000L);
        Assert.assertEquals((int)0, (int)m.exportStatusMap.size());
    }
}

