/*
 * Decompiled with CFR 0.152.
 */
package step.core.scheduler;

import ch.exense.commons.app.Configuration;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.execution.ExecutionRunnable;
import step.core.execution.ExecutionRunnableFactory;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionParameters;
import step.core.scheduler.ExecutionJob;
import step.core.scheduler.ExecutionJobFactory;
import step.core.scheduler.ExecutiontTaskParameters;

public class Executor {
    private final Logger logger = LoggerFactory.getLogger(Executor.class);
    private Scheduler scheduler;
    private SchedulerFactory schedulerFactory;
    private ExecutionRunnableFactory executionRunnableFactory;
    private Configuration configuration;
    protected static final String EXECUTION_PARAMETERS = "ExecutionParameters";
    protected static final String EXECUTION_ID = "ExecutionID";
    protected static final String EXECUTION_TASK_ID = "ExecutionTaskID";

    public Executor(GlobalContext globalContext) {
        this.configuration = globalContext.getConfiguration();
        try {
            Properties props = this.getProperties();
            this.executionRunnableFactory = new ExecutionRunnableFactory(globalContext);
            this.schedulerFactory = new StdSchedulerFactory(props);
            this.scheduler = this.schedulerFactory.getScheduler();
            this.scheduler.setJobFactory((JobFactory)new ExecutionJobFactory(globalContext, this.executionRunnableFactory));
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private Properties getProperties() {
        Properties props = new Properties();
        props.put("org.quartz.threadPool.threadCount", this.configuration.getProperty("tec.executor.threads", "10"));
        return props;
    }

    public void shutdown() {
        try {
            this.scheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteSchedule(ExecutiontTaskParameters task) {
        JobKey key = new JobKey(task.getId().toString());
        try {
            this.scheduler.deleteJob(key);
        }
        catch (SchedulerException e) {
            this.logger.error("An error occurred while removing task from scheduler: " + (Object)((Object)task));
            throw new RuntimeException(e);
        }
    }

    public void validate(ExecutiontTaskParameters task) {
        CronScheduleBuilder.cronSchedule((String)task.getCronExpression());
    }

    public boolean schedule(ExecutiontTaskParameters task) {
        JobKey key = new JobKey(task.getId().toString());
        try {
            if (this.scheduler.checkExists(key)) {
                this.deleteSchedule(task);
            }
        }
        catch (SchedulerException e) {
            this.logger.error("An error occurred while checking if task exists in scheduler: " + (Object)((Object)task));
            throw new RuntimeException(e);
        }
        Trigger trigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)task.getCronExpression())).build();
        JobDetail job = this.buildScheduledJob(task);
        this.scheduleJob(trigger, job);
        return trigger.mayFireAgain();
    }

    public String execute(ExecutionParameters executionParameters) {
        return this.execute(executionParameters, null);
    }

    public String execute(ExecutionParameters executionParameters, String executionTaskId) {
        Execution execution = this.executionRunnableFactory.createExecution(executionParameters, executionTaskId);
        Trigger trigger = TriggerBuilder.newTrigger().startNow().build();
        String executionID = execution.getId().toString();
        JobDetail job = this.buildSingleJob(executionID);
        this.scheduleJob(trigger, job);
        return executionID;
    }

    private void scheduleJob(Trigger trigger, JobDetail job) {
        try {
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            throw new RuntimeException("An unexpected error occurred while scheduling job " + job.toString(), e);
        }
    }

    private JobDetail buildSingleJob(String executionID) {
        JobDataMap data = new JobDataMap();
        data.put(EXECUTION_ID, executionID);
        return JobBuilder.newJob().ofType(ExecutionJob.class).usingJobData(data).build();
    }

    private JobDetail buildScheduledJob(ExecutiontTaskParameters task) {
        JobDataMap data = new JobDataMap();
        data.put(EXECUTION_TASK_ID, task.getId().toString());
        data.put(EXECUTION_PARAMETERS, (Object)task.getExecutionsParameters());
        return JobBuilder.newJob().ofType(ExecutionJob.class).withIdentity(task.getId().toString()).usingJobData(data).build();
    }

    public List<ExecutionRunnable> getCurrentExecutions() {
        List excutingJobs;
        try {
            excutingJobs = this.scheduler.getCurrentlyExecutingJobs();
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Unexepected error occurred while getting executing jobs", e);
        }
        ArrayList<ExecutionRunnable> result = new ArrayList<ExecutionRunnable>(excutingJobs.size());
        for (JobExecutionContext jobContext : excutingJobs) {
            result.add(((ExecutionJob)jobContext.getJobInstance()).getRunnable());
        }
        return result;
    }

    public List<ExecutiontTaskParameters> getScheduledExecutions() {
        ArrayList<ExecutiontTaskParameters> result = new ArrayList<ExecutiontTaskParameters>();
        try {
            for (String group : this.scheduler.getJobGroupNames()) {
                GroupMatcher matcher = GroupMatcher.groupEquals((String)group);
                for (JobKey jobKey : this.scheduler.getJobKeys(matcher)) {
                    JobDetail job = this.scheduler.getJobDetail(jobKey);
                    JobDataMap data = job.getJobDataMap();
                    ExecutionParameters params = (ExecutionParameters)data.get((Object)EXECUTION_PARAMETERS);
                    List triggers = this.scheduler.getTriggersOfJob(jobKey);
                    for (Trigger trigger : triggers) {
                        if (!(trigger instanceof CronTrigger)) continue;
                        ExecutiontTaskParameters p = new ExecutiontTaskParameters(params, ((CronTrigger)trigger).getCronExpression());
                        result.add(p);
                    }
                    System.out.println("Found job identified by: " + jobKey);
                }
            }
        }
        catch (SchedulerException e) {
            this.logger.error("An error occurred while getting scheduled jobs", (Throwable)e);
        }
        return result;
    }
}

