/*
 * Decompiled with CFR 0.152.
 */
package step.core.scheduler;

import java.util.Iterator;
import java.util.List;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.execution.ExecutionRunnable;
import step.core.execution.model.ExecutionParameters;
import step.core.scheduler.ExecutiontTaskParameters;
import step.core.scheduler.Executor;

public class ExecutionScheduler {
    private final Logger logger = LoggerFactory.getLogger(ExecutionScheduler.class);
    private GlobalContext context;
    private Executor executor;

    public ExecutionScheduler(GlobalContext globalContext) {
        this.context = globalContext;
        this.executor = new Executor(globalContext);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void start() {
        this.executor.start();
        this.loadExecutionTasks();
    }

    private void loadExecutionTasks() {
        Iterator<ExecutiontTaskParameters> it = this.getActiveExecutionTasks();
        while (it.hasNext()) {
            ExecutiontTaskParameters task = it.next();
            this.logger.info("Loading schedule: " + ((Object)((Object)task)).toString());
            try {
                boolean mayFireAgain = this.executor.schedule(task);
                if (mayFireAgain) continue;
                this.removeExecutionTask(task.getId().toString());
            }
            catch (Exception e) {
                this.logger.error("An error occurred while scheduling task. " + ((Object)((Object)task)).toString() + ". Disabling task.", (Throwable)e);
                this.disableExecutionTask(task.getId().toString());
            }
        }
    }

    public Iterator<ExecutiontTaskParameters> getActiveExecutionTasks() {
        return this.context.getScheduleAccessor().getActiveExecutionTasks();
    }

    public Iterator<ExecutiontTaskParameters> getActiveAndInactiveExecutionTasks() {
        return this.context.getScheduleAccessor().getAll();
    }

    public void removeExecutionTask(String executionTaskID) {
        ExecutiontTaskParameters task = this.get(executionTaskID);
        this.remove(task);
        this.executor.deleteSchedule(task);
    }

    public void enableExecutionTask(String executionTaskID) {
        ExecutiontTaskParameters task = this.get(executionTaskID);
        task.setActive(true);
        this.save(task);
        this.executor.schedule(task);
    }

    public void disableExecutionTask(String executionTaskID) {
        ExecutiontTaskParameters task = this.get(executionTaskID);
        task.setActive(false);
        this.save(task);
        this.executor.deleteSchedule(task);
    }

    public boolean addExecutionTask(ExecutiontTaskParameters task) {
        this.executor.validate(task);
        task.setActive(true);
        this.save(task);
        return this.executor.schedule(task);
    }

    public String execute(ExecutionParameters executionParameters) {
        return this.executor.execute(executionParameters);
    }

    public String executeExecutionTask(String executionTaskID, String user) {
        ExecutiontTaskParameters task = this.get(executionTaskID);
        task.getExecutionsParameters().setUserID(user);
        return this.executor.execute(task.getExecutionsParameters(), executionTaskID);
    }

    public ExecutiontTaskParameters get(String id) {
        return (ExecutiontTaskParameters)this.context.getScheduleAccessor().get(new ObjectId(id));
    }

    private void save(ExecutiontTaskParameters schedule) {
        this.context.getScheduleAccessor().save((AbstractIdentifiableObject)schedule);
    }

    private void remove(ExecutiontTaskParameters schedule) {
        this.context.getScheduleAccessor().remove(schedule.getId());
    }

    public List<ExecutionRunnable> getCurrentExecutions() {
        return this.executor.getCurrentExecutions();
    }
}

