/*
 * Decompiled with CFR 0.152.
 */
package step.core.ql;

import org.antlr.v4.runtime.tree.ParseTree;
import step.core.ql.Filter;
import step.core.ql.FilterFactory;
import step.core.ql.OQLBaseVisitor;
import step.core.ql.OQLParser;

public class OQLFilterVisitor<T>
extends OQLBaseVisitor<Filter<T>> {
    private FilterFactory<T> factory;

    public OQLFilterVisitor(FilterFactory<T> factory) {
        this.factory = factory;
    }

    @Override
    public Filter<T> visitAndExpr(OQLParser.AndExprContext ctx) {
        final Filter left = (Filter)this.visit((ParseTree)ctx.expr(0));
        final Filter right = (Filter)this.visit((ParseTree)ctx.expr(1));
        return new Filter<T>(){

            @Override
            public boolean isValid(T input) {
                return left.isValid(input) && right.isValid(input);
            }
        };
    }

    @Override
    public Filter<T> visitEqualityExpr(OQLParser.EqualityExprContext ctx) {
        return this.factory.createAttributeFilter(ctx.op.getText(), ctx.expr(0).getText(), ctx.expr(1).getText());
    }

    @Override
    public Filter<T> visitOrExpr(OQLParser.OrExprContext ctx) {
        final Filter left = (Filter)this.visit((ParseTree)ctx.expr(0));
        final Filter right = (Filter)this.visit((ParseTree)ctx.expr(1));
        return new Filter<T>(){

            @Override
            public boolean isValid(T input) {
                return left.isValid(input) || right.isValid(input);
            }
        };
    }

    @Override
    public Filter<T> visitNotExpr(OQLParser.NotExprContext ctx) {
        final Filter expr = (Filter)this.visit((ParseTree)ctx.expr());
        return new Filter<T>(){

            @Override
            public boolean isValid(T input) {
                return !expr.isValid(input);
            }
        };
    }

    @Override
    public Filter<T> visitParExpr(OQLParser.ParExprContext ctx) {
        final Filter expr = (Filter)this.visit((ParseTree)ctx.expr());
        return new Filter<T>(){

            @Override
            public boolean isValid(T input) {
                return expr.isValid(input);
            }
        };
    }

    @Override
    public Filter<T> visitNonQuotedStringAtom(OQLParser.NonQuotedStringAtomContext ctx) {
        return this.factory.createFullTextFilter(ctx.getText());
    }

    @Override
    public Filter<T> visitStringAtom(OQLParser.StringAtomContext ctx) {
        String str = ctx.getText();
        str = str.substring(1, str.length() - 1).replace("\"\"", "\"");
        return this.factory.createFullTextFilter(str);
    }
}

