/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution;

import java.util.ArrayList;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionLifecycleManager;
import step.core.execution.ExecutionManager;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionAccessor;
import step.core.execution.model.ExecutionStatus;
import step.core.execution.model.ReportExport;
import step.core.repositories.ImportResult;
import step.core.repositories.RepositoryObjectManager;
import step.core.repositories.RepositoryObjectReference;

public class ExecutionRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionRunnable.class);
    final RepositoryObjectManager repositoryObjectManager;
    final ExecutionAccessor executionAccessor;
    final ExecutionContext context;
    final ExecutionLifecycleManager executionLifecycleManager;

    public ExecutionRunnable(RepositoryObjectManager repositoryObjectManager, ExecutionAccessor executionAccessor, ExecutionContext context) {
        this.repositoryObjectManager = repositoryObjectManager;
        this.executionAccessor = executionAccessor;
        this.context = context;
        this.executionLifecycleManager = new ExecutionLifecycleManager((ExecutionManager)context.get(ExecutionManager.class), context);
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.context.associateThread();
            ReportNode rootReportNode = this.createAndPersistRootReportNode();
            this.executionLifecycleManager.executionStarted();
            this.updateStatus(ExecutionStatus.IMPORTING);
            ImportResult importResult = this.importArtefact();
            this.executionLifecycleManager.afterImport(importResult);
            if (importResult.isSuccessful()) {
                AbstractArtefact artefact = this.context.getArtefactAccessor().get(importResult.getArtefactId());
                this.context.setArtefact(artefact);
                logger.info("Starting test execution. Execution ID: " + this.context.getExecutionId());
                this.updateStatus(ExecutionStatus.RUNNING);
                ArtefactHandler.delegateCreateReportSkeleton((ExecutionContext)this.context, (AbstractArtefact)artefact, (ReportNode)rootReportNode);
                ReportNode planReportNode = ArtefactHandler.delegateExecute((ExecutionContext)this.context, (AbstractArtefact)artefact, (ReportNode)rootReportNode);
                if (planReportNode != null && planReportNode.getStatus() != null) {
                    ReportNodeStatus resultStatus = planReportNode.getStatus();
                    this.executionLifecycleManager.updateExecutionResult(this.context, resultStatus);
                    rootReportNode.setStatus(resultStatus);
                    this.context.getReportNodeAccessor().save((AbstractIdentifiableObject)rootReportNode);
                }
                logger.debug("Test execution ended. Reporting result.... Execution ID: " + this.context.getExecutionId());
                if (!this.context.isSimulation()) {
                    this.updateStatus(ExecutionStatus.EXPORTING);
                    this.exportExecution(this.context.getExecutionId());
                    logger.info("Test execution ended and reported. Execution ID: " + this.context.getExecutionId());
                } else {
                    logger.info("Test execution simulation ended. Test report isn't reported in simulation mode. Execution ID: " + this.context.getExecutionId());
                }
            } else {
                this.updateStatus(ExecutionStatus.ENDED);
            }
        }
        catch (Throwable e) {
            logger.error("An error occurred while running test. Execution ID: " + this.context.getExecutionId(), e);
        }
        finally {
            this.updateStatus(ExecutionStatus.ENDED);
            this.executionLifecycleManager.executionEnded();
        }
    }

    private ReportNode createAndPersistRootReportNode() {
        ReportNode resultNode = new ReportNode();
        resultNode.setExecutionID(this.context.getExecutionId());
        resultNode.setId(new ObjectId(this.context.getExecutionId()));
        this.context.setReport(resultNode);
        this.context.getReportNodeCache().put(resultNode);
        this.context.getReportNodeAccessor().save((AbstractIdentifiableObject)resultNode);
        this.context.setCurrentReportNode(resultNode);
        return resultNode;
    }

    private void updateStatus(ExecutionStatus newStatus) {
        this.executionLifecycleManager.updateStatus(newStatus);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ImportResult importArtefact() throws Exception {
        ImportResult importResult;
        if (this.context.getExecutionParameters().getArtefact() == null) return null;
        RepositoryObjectReference artefactPointer = this.context.getExecutionParameters().getArtefact();
        if (artefactPointer == null) throw new Exception("context.artefactID is null and no ArtefactPointer has been specified. This shouldn't happen.");
        if ("local".equals(artefactPointer.getRepositoryID())) {
            importResult = new ImportResult();
            importResult.setArtefactId((String)artefactPointer.getRepositoryParameters().get("artefactid"));
            importResult.setSuccessful(true);
            return importResult;
        } else {
            try {
                return this.repositoryObjectManager.importArtefact(this.context, artefactPointer);
            }
            catch (Exception e) {
                logger.error("Error while importing repository object " + artefactPointer.toString(), (Throwable)e);
                importResult = new ImportResult();
                String error = "Unexpected error while importing plan: " + e.getMessage();
                ArrayList<String> errors = new ArrayList<String>();
                errors.add(error);
                importResult.setErrors(errors);
            }
        }
        return importResult;
    }

    private void exportExecution(String executionId) {
        Execution execution = this.executionAccessor.get(executionId);
        if (execution == null) {
            throw new RuntimeException("Unable to find execution with id " + executionId);
        }
        ReportExport report = this.repositoryObjectManager.exportTestExecutionReport(this.context, execution.getExecutionParameters().getArtefact());
        ArrayList<ReportExport> exports = new ArrayList<ReportExport>();
        exports.add(report);
        execution.setReportExports(exports);
        this.executionAccessor.save((AbstractIdentifiableObject)execution);
    }

    public ExecutionLifecycleManager getExecutionLifecycleManager() {
        return this.executionLifecycleManager;
    }

    public boolean equals(Object obj) {
        return ((ExecutionRunnable)obj).getContext().getExecutionId().equals(this.getContext().getExecutionId());
    }

    public void cleanUp() {
    }
}

