/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import step.core.accessors.MongoClientSession;

public class AbstractAccessor {
    protected MongoClientSession mongoClientSession;

    public AbstractAccessor() {
    }

    public AbstractAccessor(MongoClientSession mongoClientSession) {
        this.mongoClientSession = mongoClientSession;
    }

    protected org.jongo.MongoCollection getJongoCollection(String collectionName) {
        return this.mongoClientSession.getJongoCollection(collectionName);
    }

    protected MongoCollection<Document> getMongoCollection(String collectionName) {
        return this.mongoClientSession.getMongoDatabase().getCollection(collectionName);
    }

    public static void createOrUpdateIndex(MongoCollection<Document> collection, String attribute) {
        Document index = AbstractAccessor.getIndex(collection, attribute);
        if (index == null) {
            collection.createIndex((Bson)new Document(attribute, (Object)1));
        }
    }

    public static void createOrUpdateCompoundIndex(MongoCollection<Document> collection, String ... attribute) {
        Document index = AbstractAccessor.getIndex(collection, attribute);
        if (index == null) {
            Document newIndex = new Document();
            for (String s : attribute) {
                newIndex.append(s, (Object)1);
            }
            collection.createIndex((Bson)newIndex);
        }
    }

    protected void createOrUpdateTTLIndex(MongoCollection<Document> collection, String attribute, Long ttl) {
        Document ttlIndex = AbstractAccessor.getIndex(collection, attribute);
        if (ttlIndex == null) {
            if (ttl != null && ttl > 0L) {
                this.createTimestampIndexWithTTL(collection, attribute, ttl);
            } else {
                this.createTimestampIndex(collection, attribute);
            }
        } else if (ttl != null && ttl > 0L) {
            if (!ttlIndex.containsKey((Object)"expireAfterSeconds") || !ttlIndex.getLong((Object)"expireAfterSeconds").equals(ttl)) {
                this.dropIndex(collection, ttlIndex);
                this.createTimestampIndexWithTTL(collection, attribute, ttl);
            }
        } else if (ttlIndex.containsKey((Object)"expireAfterSeconds")) {
            this.dropIndex(collection, ttlIndex);
            this.createTimestampIndex(collection, attribute);
        }
    }

    private void dropIndex(MongoCollection<Document> collection, Document ttlIndex) {
        collection.dropIndex(ttlIndex.getString((Object)"name"));
    }

    private void createTimestampIndexWithTTL(MongoCollection<Document> collection, String attribute, Long ttl) {
        IndexOptions options = new IndexOptions();
        options.expireAfter(ttl, TimeUnit.SECONDS);
        this.createTimestampIndexWithOptions(collection, attribute, options);
    }

    private void createTimestampIndex(MongoCollection<Document> collection, String attribute) {
        IndexOptions options = new IndexOptions();
        this.createTimestampIndexWithOptions(collection, attribute, options);
    }

    private void createTimestampIndexWithOptions(MongoCollection<Document> collection, String attribute, IndexOptions options) {
        collection.createIndex((Bson)new Document(attribute, (Object)1), options);
    }

    private static Document getIndex(MongoCollection<Document> collection, String ... attribute) {
        HashSet<String> attributes = new HashSet<String>(Arrays.asList(attribute));
        for (Document index : collection.listIndexes()) {
            Document d;
            Object o = index.get((Object)"key");
            if (!(o instanceof Document) || !attributes.equals((d = (Document)o).keySet())) continue;
            return d;
        }
        return null;
    }
}

