/*
 * Decompiled with CFR 0.152.
 */
package step.controller;

import ch.exense.commons.app.ArgumentParser;
import ch.exense.commons.app.Configuration;
import java.io.File;
import java.io.IOException;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.Controller;
import step.core.deployment.AccessServices;
import step.core.deployment.AdminServices;
import step.core.deployment.ApplicationServices;
import step.core.deployment.AuthenticationFilter;
import step.core.deployment.ControllerServices;
import step.core.deployment.ErrorFilter;
import step.core.deployment.JacksonMapperProvider;
import step.plugins.interactive.InteractiveServices;

public class ControllerServer {
    private Configuration configuration;
    private Controller controller;
    private Server server;
    private ContextHandlerCollection handlers;
    private Integer port;
    private static final Logger logger = LoggerFactory.getLogger(ControllerServer.class);

    public static void main(String[] args) throws Exception {
        ArgumentParser arguments = new ArgumentParser(args);
        String configStr = arguments.getOption("config");
        Configuration configuration = configStr != null ? new Configuration(new File(configStr), arguments.getOptions()) : new Configuration();
        arguments.entrySet().forEach(e -> configuration.putProperty((String)e.getKey(), (String)e.getValue()));
        new ControllerServer(configuration).start();
    }

    public ControllerServer(Configuration configuration) {
        this.configuration = configuration;
        this.port = configuration.getPropertyAsInteger("port", Integer.valueOf(8080));
    }

    public void start() throws Exception {
        this.server = new Server();
        this.handlers = new ContextHandlerCollection();
        this.initController();
        this.initWebapp();
        this.setupConnectors();
        this.server.setHandler((Handler)this.handlers);
        this.server.start();
    }

    private void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.error("Error while stopping jetty", (Throwable)e);
        }
        finally {
            this.server.destroy();
        }
        if (this.configuration != null) {
            try {
                this.configuration.close();
            }
            catch (IOException e) {
                logger.error("Error while closing configuration", (Throwable)e);
            }
        }
    }

    private void setupConnectors() {
        HttpConfiguration http = new HttpConfiguration();
        http.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        http.setSecureScheme("https");
        ServerConnector connector = new ServerConnector(this.server);
        connector.addConnectionFactory((ConnectionFactory)new HttpConnectionFactory(http));
        connector.setPort(this.port.intValue());
        if (this.configuration.getPropertyAsBoolean("ui.ssl.enabled", false)) {
            int httpsPort = this.configuration.getPropertyAsInteger("ui.ssl.port", Integer.valueOf(443));
            http.setSecurePort(httpsPort);
            HttpConfiguration https = new HttpConfiguration();
            https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(this.configuration.getProperty("ui.ssl.keystore.path"));
            sslContextFactory.setKeyStorePassword(this.configuration.getProperty("ui.ssl.keystore.password"));
            sslContextFactory.setKeyManagerPassword(this.configuration.getProperty("ui.ssl.keymanager.password"));
            ServerConnector sslConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)});
            sslConnector.setPort(httpsPort);
            this.server.addConnector((Connector)sslConnector);
        }
        this.server.addConnector((Connector)connector);
    }

    private void initWebapp() throws Exception {
        ResourceHandler bb = new ResourceHandler();
        bb.setResourceBase(Resource.newClassPathResource((String)"webapp").getURI().toString());
        ContextHandler ctx = new ContextHandler("/");
        ctx.setHandler((Handler)bb);
        this.addHandler((Handler)ctx);
    }

    private void initController() throws Exception {
        final ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.packages(new String[]{ControllerServices.class.getPackage().getName()});
        this.controller = new Controller(this.configuration);
        this.controller.init(new Controller.ServiceRegistrationCallback(){

            public void registerService(Class<?> serviceClass) {
                resourceConfig.registerClasses(new Class[]{serviceClass});
            }

            public void registerHandler(Handler handler) {
                ControllerServer.this.addHandler(handler);
            }

            public void stop() {
                try {
                    ControllerServer.this.stop();
                }
                catch (Exception e) {
                    logger.error("Error while trying to stop the controller", (Throwable)e);
                }
            }
        });
        resourceConfig.register(JacksonMapperProvider.class);
        resourceConfig.register(MultiPartFeature.class);
        resourceConfig.registerClasses(new Class[]{ApplicationServices.class});
        resourceConfig.registerClasses(new Class[]{ControllerServices.class});
        resourceConfig.registerClasses(new Class[]{InteractiveServices.class});
        resourceConfig.registerClasses(new Class[]{AccessServices.class});
        resourceConfig.registerClasses(new Class[]{AuthenticationFilter.class});
        resourceConfig.registerClasses(new Class[]{ErrorFilter.class});
        resourceConfig.registerClasses(new Class[]{AdminServices.class});
        resourceConfig.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(ControllerServer.this.controller).to(Controller.class);
            }
        });
        ServletContainer servletContainer = new ServletContainer(resourceConfig);
        ServletHolder sh = new ServletHolder((Servlet)servletContainer);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/rest");
        context.addServlet(sh, "/*");
        this.addHandler((Handler)context);
    }

    private synchronized void addHandler(Handler handler) {
        this.handlers.addHandler(handler);
    }
}

