/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.scripteditor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import step.core.deployment.AbstractServices;
import step.functions.Function;
import step.functions.manager.FunctionManager;
import step.functions.type.FunctionTypeRegistry;
import step.plugins.java.AbstractScriptFunctionType;
import step.plugins.java.GeneralScriptFunction;

@Singleton
@Path(value="/scripteditor")
public class ScriptEditorServices
extends AbstractServices {
    @GET
    @Path(value="/file/{filename}")
    public String getScript(@PathParam(value="filename") String filename) throws IOException {
        File scriptFIle = new File(this.configuration.getProperty("keywords.script.scriptdir") + "/" + filename);
        byte[] encoded = Files.readAllBytes(Paths.get(scriptFIle.toURI()));
        return new String(encoded, "UTF-8");
    }

    @POST
    @Path(value="/file/{filename}")
    public void saveScript(@PathParam(value="filename") String filename, String content) throws IOException {
        File scriptFile = new File(this.configuration.getProperty("keywords.script.scriptdir") + "/" + filename);
        Files.write(Paths.get(scriptFile.toURI()), content.getBytes("UTF-8"), new OpenOption[0]);
    }

    @POST
    @Path(value="/function/{functionid}/file")
    public void saveFunctionScript(@PathParam(value="functionid") String functionid, String content) throws IOException {
        File scriptFile = this.getScriptFile(functionid);
        Files.write(Paths.get(scriptFile.toURI()), content.getBytes("UTF-8"), new OpenOption[0]);
    }

    @GET
    @Path(value="/function/{functionid}/file")
    public String getFunctionScript(@PathParam(value="functionid") String functionid) throws IOException {
        File scriptFile = this.getScriptFile(functionid);
        byte[] encoded = Files.readAllBytes(Paths.get(scriptFile.toURI()));
        return new String(encoded, "UTF-8");
    }

    private File getScriptFile(String functionid) {
        FunctionManager functionManager = (FunctionManager)this.getContext().get(FunctionManager.class);
        GeneralScriptFunction function = (GeneralScriptFunction)functionManager.getFunctionById(functionid);
        FunctionTypeRegistry functionTypeRegistry = (FunctionTypeRegistry)this.getContext().get(FunctionTypeRegistry.class);
        return ((AbstractScriptFunctionType)functionTypeRegistry.getFunctionTypeByFunction((Function)function)).getScriptFile(function);
    }
}

