/*
 * Decompiled with CFR 0.152.
 */
package step.rtm;

import com.mongodb.client.MongoCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.rtm.commons.Configuration;
import org.rtm.commons.MeasurementAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.artefacts.reports.CallFunctionReportNode;
import step.core.GlobalContext;
import step.core.accessors.AbstractAccessor;
import step.core.artefacts.reports.ReportNode;
import step.core.plugins.AbstractControllerPlugin;
import step.core.plugins.Plugin;
import step.core.reports.Measure;
import step.rtm.RtmPluginServices;

@Plugin
public class RtmPlugin
extends AbstractControllerPlugin {
    private static final Logger logger = LoggerFactory.getLogger(RtmPlugin.class);
    public static final String ATTRIBUTE_EXECUTION_ID = "eId";
    MeasurementAccessor accessor;
    boolean measureReportNodes;

    public void executionControllerStart(GlobalContext context) throws Exception {
        context.getServiceRegistrationCallback().registerService(RtmPluginServices.class);
        Properties rtmProperties = Configuration.getInstance().getUnderlyingPropertyObject();
        ch.exense.commons.app.Configuration stepProperties = context.getConfiguration();
        String[] propArray = new String[]{"db.host", "db.port", "db.database", "db.username", "db.password"};
        List<String> props = Arrays.asList(propArray);
        if (stepProperties.getPropertyAsBoolean("plugins.rtm.useLocalDB", true)) {
            logger.info("Property 'plugins.rtm.useLocalDB' is set to true, overriding rtm db properties with step ones:");
            for (String prop : props) {
                logger.info("[" + prop + "] " + rtmProperties.getProperty(prop) + "->" + stepProperties.getProperty(prop));
                this.cloneProperty(rtmProperties, stepProperties, prop);
            }
        } else {
            logger.info("Property 'plugins.rtm.useLocalDB' is set to false, rtm will use it's own database connection info:");
            for (String prop : props) {
                logger.info("[" + prop + "] " + rtmProperties.getProperty(prop));
            }
        }
        this.measureReportNodes = stepProperties.getPropertyAsBoolean("plugins.rtm.measurereportnodes", true);
        MongoCollection measurements = context.getMongoClientSession().getMongoDatabase().getCollection("measurements");
        AbstractAccessor.createOrUpdateCompoundIndex((MongoCollection)measurements, (String[])new String[]{ATTRIBUTE_EXECUTION_ID, "begin"});
        AbstractAccessor.createOrUpdateIndex((MongoCollection)measurements, (String)"begin");
        WebAppContext webappCtx = new WebAppContext();
        webappCtx.setContextPath("/rtm");
        String war = stepProperties.getProperty("plugins.rtm.war");
        if (war == null) {
            throw new RuntimeException("Property 'plugins.rtm.war' is null. Unable to start RTM.");
        }
        File warFile = new File(war);
        if (!warFile.exists() || !warFile.canRead()) {
            throw new RuntimeException("The file '" + war + "' with absolute path '" + warFile.getAbsolutePath() + "' set by the property 'plugins.rtm.war' doesn't exist or cannot be read. Unable to start RTM.");
        }
        webappCtx.setWar(war);
        webappCtx.setParentLoaderPriority(true);
        context.getServiceRegistrationCallback().registerHandler((Handler)webappCtx);
        this.accessor = MeasurementAccessor.getInstance();
        context.put(MeasurementAccessor.class, (Object)this.accessor);
    }

    public void executionControllerDestroy(GlobalContext context) {
        if (this.accessor != null) {
            this.accessor.close();
        }
    }

    private void cloneProperty(Properties rtmProperties, ch.exense.commons.app.Configuration stepProperties, String property) {
        if (stepProperties.getProperty(property) != null) {
            rtmProperties.put(property, stepProperties.getProperty(property));
        }
    }

    public void afterReportNodeExecution(ReportNode node) {
        if (node instanceof CallFunctionReportNode) {
            HashMap<String, Object> measurement;
            CallFunctionReportNode stepReport = (CallFunctionReportNode)node;
            Map functionAttributes = stepReport.getFunctionAttributes();
            ArrayList<Object> measurements = new ArrayList<Object>();
            if (this.measureReportNodes) {
                measurement = new HashMap<String, Object>();
                if (functionAttributes != null) {
                    measurement.putAll(functionAttributes);
                }
                measurement.put(ATTRIBUTE_EXECUTION_ID, stepReport.getExecutionID());
                measurement.put("value", Long.valueOf(stepReport.getDuration().intValue()));
                measurement.put("begin", stepReport.getExecutionTime());
                measurement.put("rnId", stepReport.getId().toString());
                measurement.put("rnStatus", stepReport.getStatus().toString());
                measurement.put("type", "keyword");
                measurements.add(measurement);
            }
            if (stepReport.getMeasures() != null) {
                for (Measure measure : stepReport.getMeasures()) {
                    measurement = new HashMap();
                    measurement.putAll(functionAttributes);
                    measurement.put(ATTRIBUTE_EXECUTION_ID, stepReport.getExecutionID());
                    measurement.put("name", measure.getName());
                    measurement.put("origin", stepReport.getFunctionAttributes().get("name"));
                    measurement.put("value", measure.getDuration());
                    measurement.put("begin", measure.getBegin());
                    measurement.put("rnId", stepReport.getId().toString());
                    measurement.put("rnStatus", stepReport.getStatus().toString());
                    measurement.put("type", "custom");
                    if (measure.getData() != null) {
                        for (Map.Entry entry : measure.getData().entrySet()) {
                            String key = (String)entry.getKey();
                            Object val = entry.getValue();
                            if (key == null || val == null) continue;
                            if (val instanceof Long || val instanceof String) {
                                measurement.put(key, val);
                                continue;
                            }
                            if (!(val instanceof Number)) continue;
                            measurement.put(key, ((Integer)val).longValue());
                        }
                    }
                    measurements.add(measurement);
                }
            }
            this.accessor.saveManyMeasurements(measurements);
            if (logger.isTraceEnabled()) {
                RtmPlugin.logMeasurements(measurements);
            }
        }
    }

    public static void logMeasurements(List<Object> measurements) {
        for (Object o : measurements) {
            logger.trace("RTM measure:" + o.toString());
        }
    }
}

