/*
 * Decompiled with CFR 0.152.
 */
package step.migration.tasks;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import org.bson.Document;
import org.bson.conversions.Bson;
import step.core.GlobalContext;
import step.core.Version;
import step.migration.MigrationTask;

public class RemoveLocalFunctions
extends MigrationTask {
    public RemoveLocalFunctions() {
        super(new Version(3, 13, 0));
    }

    @Override
    public void runUpgradeScript() {
        this.removeLocalFunctions(this.context);
    }

    private void removeLocalFunctions(GlobalContext context) {
        logger.info("Searching for keywords of type 'LocalFunction' to be deleted...");
        MongoCollection functions = context.getMongoClientSession().getMongoDatabase().getCollection("functions");
        Document filter = new Document("type", (Object)"step.functions.base.types.LocalFunction");
        DeleteResult result = functions.deleteMany((Bson)filter);
        logger.info("Removed " + result.getDeletedCount() + " keywords of type 'LocalFunction'");
    }

    @Override
    public void runDowngradeScript() {
    }
}

