/*
 * Decompiled with CFR 0.152.
 */
package step.migration.tasks;

import ch.exense.commons.app.ArgumentParser;
import ch.exense.commons.app.Configuration;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.jongo.Mapper;
import org.jongo.bson.Bson;
import org.jongo.marshall.Unmarshaller;
import org.jongo.marshall.jackson.JacksonMapper;
import step.artefacts.CallPlan;
import step.core.GlobalContext;
import step.core.Version;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.AccessorLayerJacksonMapperProvider;
import step.core.accessors.MongoClientSession;
import step.core.accessors.PlanAccessorImpl;
import step.core.artefacts.AbstractArtefact;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionAccessorImpl;
import step.core.plans.Plan;
import step.core.scheduler.ExecutionTaskAccessorImpl;
import step.core.scheduler.ExecutiontTaskParameters;
import step.functions.accessor.FunctionAccessorImpl;
import step.functions.accessor.FunctionCRUDAccessor;
import step.migration.MigrationTask;
import step.plugins.functions.types.CompositeFunction;

public class MigrateArtefactsToPlans
extends MigrationTask {
    private static final String CHILDREN_ID_FIELD = "childrenIDs";
    private MongoDatabase mongoDatabase;
    private MongoCollection<Document> artefactCollection;
    private MongoCollection<Document> functionCollection;
    private MongoCollection<Document> executionCollection;
    private MongoCollection<Document> tasksCollection;
    private PlanAccessorImpl planAccessor;
    private ExecutionAccessorImpl executionAccessor;
    private ExecutionTaskAccessorImpl executionTaskAccessor;
    private FunctionCRUDAccessor functionAccessor;
    private Mapper dbLayerObjectMapper;
    private Map<ObjectId, ObjectId> artefactIdToPlanId;
    private Unmarshaller unmarshaller;

    public MigrateArtefactsToPlans() {
        super(new Version(3, 13, 0));
    }

    @Override
    protected void setContext(GlobalContext context) {
        super.setContext(context);
        this.init(context.getMongoClientSession());
        context.put(MigrateArtefactsToPlans.class, (Object)this);
    }

    protected void init(MongoClientSession mongoClientSession) {
        this.mongoDatabase = mongoClientSession.getMongoDatabase();
        this.artefactCollection = this.mongoDatabase.getCollection("artefacts");
        this.executionCollection = this.mongoDatabase.getCollection("executions");
        this.functionCollection = this.mongoDatabase.getCollection("functions");
        this.tasksCollection = this.mongoDatabase.getCollection("tasks");
        JacksonMapper.Builder builder2 = new JacksonMapper.Builder();
        AccessorLayerJacksonMapperProvider.getModules().forEach(m -> builder2.registerModule(m));
        this.dbLayerObjectMapper = builder2.build();
        this.unmarshaller = this.dbLayerObjectMapper.getUnmarshaller();
        this.planAccessor = new PlanAccessorImpl(mongoClientSession);
        this.executionAccessor = new ExecutionAccessorImpl(mongoClientSession);
        this.executionTaskAccessor = new ExecutionTaskAccessorImpl(mongoClientSession);
        this.functionAccessor = new FunctionAccessorImpl(mongoClientSession);
        this.artefactIdToPlanId = new HashMap<ObjectId, ObjectId>();
    }

    @Override
    public void runUpgradeScript() {
        int count = this.generatePlanIds();
        logger.info("Found " + count + " root artefacts to be migrated. Starting migration...");
        this.migrateArtefactsToPlans();
        this.migrateCompositeFunctionsFunctions();
        this.migrateExecutions();
        this.migrateSchedulerTasks();
        this.renameArtefactCollection();
    }

    protected void renameArtefactCollection() {
        String newArtefactsCollectionName = "artefacts_migrated";
        logger.info("Renaming collection 'artefacts' to '" + newArtefactsCollectionName + "'. This collection won't be used by step anymore. You can drop it if all your plans have been migrated without error.");
        this.artefactCollection.renameCollection(new MongoNamespace(this.mongoDatabase.getName(), newArtefactsCollectionName));
    }

    private int generatePlanIds() {
        logger.info("Searching for root artefacts to be migrated...");
        AtomicInteger count = new AtomicInteger();
        Document filterRootArtefacts = new Document("root", (Object)true);
        this.artefactCollection.find((org.bson.conversions.Bson)filterRootArtefacts, BasicDBObject.class).iterator().forEachRemaining(t -> {
            try {
                ObjectId objectId = t.getObjectId("_id");
                this.artefactIdToPlanId.put(objectId, new ObjectId());
                count.incrementAndGet();
            }
            catch (Exception e) {
                logger.error("Invalid object id found for the root artefact", (Throwable)e);
            }
        });
        return count.get();
    }

    private void migrateArtefactsToPlans() {
        AtomicInteger successCount = new AtomicInteger();
        AtomicInteger errorCount = new AtomicInteger();
        Document filterRootArtefacts = new Document("root", (Object)true);
        this.artefactCollection.find((org.bson.conversions.Bson)filterRootArtefacts, BasicDBObject.class).iterator().forEachRemaining(t -> this.migrateArtefactToPlan(successCount, errorCount, (BasicDBObject)t));
        logger.info("Migrated " + successCount.get() + " artefacts successfully.");
        if (errorCount.get() > 0) {
            logger.error(errorCount.get() + " artefacts couldn't be migrated. See error logs for details");
        }
        successCount.set(0);
        errorCount.set(0);
    }

    protected Plan migrateArtefactToPlan(BasicDBObject t) {
        return this.migrateArtefactToPlan(null, null, t);
    }

    protected Plan migrateArtefactToPlan(AtomicInteger successCount, AtomicInteger errorCount, BasicDBObject t) {
        HashMap attributes = new HashMap();
        try {
            BasicDBObject document = (BasicDBObject)t.get("attributes");
            if (document != null) {
                document.keySet().forEach(key -> attributes.put(key, document.getString(key)));
            }
            AbstractArtefact artefact = this.unmarshallArtefact(t);
            Plan plan = new Plan();
            plan.setId(this.artefactIdToPlanId.get(artefact.getId()));
            plan.setAttributes(attributes);
            plan.setRoot(artefact);
            plan.setVisible(true);
            logger.info("Migrated plan " + attributes);
            plan = (Plan)this.planAccessor.save((AbstractIdentifiableObject)plan);
            if (successCount != null) {
                successCount.incrementAndGet();
            }
            return plan;
        }
        catch (Exception e) {
            logger.error("Error while migrating plan " + attributes, (Throwable)e);
            if (errorCount != null) {
                errorCount.incrementAndGet();
            }
            return null;
        }
    }

    private AbstractArtefact unmarshallArtefact(BasicDBObject t) {
        String artefactId;
        List childrendIDs = null;
        if (t.containsField(CHILDREN_ID_FIELD)) {
            childrendIDs = (List)t.get(CHILDREN_ID_FIELD);
        }
        t.remove((Object)CHILDREN_ID_FIELD);
        AbstractArtefact artefact = (AbstractArtefact)this.unmarshaller.unmarshall(Bson.createDocument((DBObject)t), AbstractArtefact.class);
        if (artefact instanceof CallPlan && (artefactId = t.getString("artefactId")) != null) {
            ObjectId referencedPlanId = this.artefactIdToPlanId.get(new ObjectId(artefactId));
            if (referencedPlanId != null) {
                ((CallPlan)artefact).setPlanId(referencedPlanId.toString());
            } else {
                logger.warn("The artefact " + artefactId + " referenced by the artefact (call plan) " + t.getObjectId("_id").toString() + " doesn't exist");
            }
        }
        if (childrendIDs != null) {
            childrendIDs.forEach(childID -> {
                BasicDBObject child = (BasicDBObject)this.artefactCollection.find((org.bson.conversions.Bson)new Document("_id", childID), BasicDBObject.class).first();
                AbstractArtefact artefactChild = this.unmarshallArtefact(child);
                artefact.getChildren().add(artefactChild);
            });
        }
        return artefact;
    }

    private void migrateCompositeFunctionsFunctions() {
        AtomicInteger successCount = new AtomicInteger();
        AtomicInteger errorCount = new AtomicInteger();
        Document filterCompositeFunction = new Document("type", (Object)CompositeFunction.class.getName());
        this.functionCollection.find((org.bson.conversions.Bson)filterCompositeFunction, BasicDBObject.class).iterator().forEachRemaining(t -> {
            try {
                if (t.containsField("artefactId")) {
                    String id = t.getString("_id");
                    String artefactId = t.getString("artefactId");
                    BasicDBObject rootArtefact = (BasicDBObject)this.artefactCollection.find((org.bson.conversions.Bson)new Document("_id", (Object)new ObjectId(artefactId)), BasicDBObject.class).first();
                    if (rootArtefact != null) {
                        Plan plan = this.migrateArtefactToPlan(rootArtefact);
                        if (plan != null) {
                            ObjectId planId = plan.getId();
                            t.put((Object)"planId", (Object)planId);
                            t.remove((Object)"artefactId");
                            CompositeFunction compositeFunction = (CompositeFunction)this.unmarshaller.unmarshall(Bson.createDocument((DBObject)t), CompositeFunction.class);
                            this.functionAccessor.save((AbstractIdentifiableObject)compositeFunction);
                            successCount.incrementAndGet();
                        } else {
                            errorCount.incrementAndGet();
                            logger.error("Error while migrating plan for composite function " + id + " with artefactId " + artefactId);
                        }
                    } else {
                        errorCount.incrementAndGet();
                        logger.error("Unable to find root artefact for composite function " + id + " with artefactId " + artefactId);
                    }
                }
            }
            catch (Exception e) {
                errorCount.incrementAndGet();
                logger.error("Unexpected error while migrating composite function " + t, (Throwable)e);
            }
        });
        logger.info("Migrated " + successCount.get() + " composite functions successfully.");
        if (errorCount.get() > 0) {
            logger.error("Got " + errorCount + " errors while migrating composite functions. See previous error logs for details.");
        }
    }

    private void migrateExecutions() {
        AtomicInteger successCount = new AtomicInteger();
        AtomicInteger errorCount = new AtomicInteger();
        logger.info("Searching for executions be migrated...");
        this.executionCollection.find(BasicDBObject.class).iterator().forEachRemaining(t -> {
            try {
                BasicDBObject object = (BasicDBObject)t.get("executionParameters");
                ExecutionParametersMigrationResult executionParameterMigrationResult = this.migrateExecutionParameter(object);
                if (executionParameterMigrationResult.executionParametersUpdated) {
                    Execution execution = (Execution)this.unmarshaller.unmarshall(Bson.createDocument((DBObject)t), Execution.class);
                    execution.setPlanId(executionParameterMigrationResult.planId);
                    this.executionAccessor.save((AbstractIdentifiableObject)execution);
                    successCount.incrementAndGet();
                }
            }
            catch (Exception e) {
                errorCount.incrementAndGet();
                logger.error("Error while migrating execution " + t, (Throwable)e);
            }
        });
        logger.info("Migrated " + successCount.get() + " executions successfully.");
        if (errorCount.get() > 0) {
            logger.error("Got " + errorCount + " errors while migrating executions. See previous error logs for details.");
        }
    }

    protected ExecutionParametersMigrationResult migrateExecutionParameter(BasicDBObject object) {
        BasicDBObject artefact;
        ExecutionParametersMigrationResult result = new ExecutionParametersMigrationResult();
        if (object != null && (artefact = (BasicDBObject)object.get("artefact")) != null) {
            String planIdString;
            result.planId = planIdString = this.migrateRepositoryObjectReference(artefact);
            object.put((Object)"repositoryObject", (Object)artefact);
            object.remove((Object)"artefact");
            result.executionParametersUpdated = true;
        }
        return result;
    }

    protected String migrateRepositoryObjectReference(BasicDBObject artefact) {
        String artefactId;
        String result = null;
        BasicDBObject repositoryParameters = (BasicDBObject)artefact.get("repositoryParameters");
        if (repositoryParameters != null && (artefactId = repositoryParameters.getString("artefactid")) != null) {
            ObjectId planId = this.artefactIdToPlanId.get(new ObjectId(artefactId));
            if (planId != null) {
                String planIdString = planId.toString();
                repositoryParameters.put((Object)"planid", (Object)planIdString);
                result = planIdString;
            }
            repositoryParameters.remove((Object)"artefactid");
        }
        return result;
    }

    private void migrateSchedulerTasks() {
        this.tasksCollection.find(BasicDBObject.class).iterator().forEachRemaining(t -> {
            BasicDBObject executionsParameters = (BasicDBObject)t.get("executionsParameters");
            ExecutionParametersMigrationResult executionParameterMigrationResult = this.migrateExecutionParameter(executionsParameters);
            if (executionParameterMigrationResult.executionParametersUpdated) {
                ExecutiontTaskParameters executionTaskParameters = (ExecutiontTaskParameters)this.unmarshaller.unmarshall(Bson.createDocument((DBObject)t), ExecutiontTaskParameters.class);
                this.executionTaskAccessor.save((AbstractIdentifiableObject)executionTaskParameters);
            }
        });
    }

    public static void main(String[] args) throws IOException {
        Configuration configuration;
        ArgumentParser arguments = new ArgumentParser(args);
        if (arguments.hasOption("config")) {
            configuration = new Configuration(new File(arguments.getOption("config")));
        } else {
            configuration = new Configuration();
            configuration.putProperty("db.host", "localhost");
        }
        MongoClientSession mongoClientSession = new MongoClientSession(configuration);
        MigrateArtefactsToPlans task = new MigrateArtefactsToPlans();
        task.init(mongoClientSession);
        task.runUpgradeScript();
    }

    @Override
    public void runDowngradeScript() {
    }

    protected static class ExecutionParametersMigrationResult {
        boolean executionParametersUpdated;
        String planId;

        protected ExecutionParametersMigrationResult() {
        }
    }
}

