/*
 * Decompiled with CFR 0.152.
 */
package step.migration.tasks;

import java.util.HashMap;
import java.util.Iterator;
import org.bson.types.ObjectId;
import step.artefacts.CallFunction;
import step.artefacts.CallPlan;
import step.core.Version;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.Artefact;
import step.core.artefacts.ArtefactAccessor;
import step.functions.Function;
import step.functions.accessor.FunctionAccessorImpl;
import step.migration.MigrationTask;

public class SetArtefactNamesIfEmpty
extends MigrationTask {
    public SetArtefactNamesIfEmpty() {
        super(new Version(3, 4, 0));
    }

    @Override
    public void runUpgradeScript() {
        FunctionAccessorImpl functionRepository = new FunctionAccessorImpl(this.context.getMongoClientSession());
        ArtefactAccessor a = this.context.getArtefactAccessor();
        Iterator it = a.getAll();
        while (it.hasNext()) {
            AbstractArtefact calledArtefact;
            CallPlan callPlan;
            AbstractArtefact artefact = (AbstractArtefact)it.next();
            HashMap<String, String> attributes = artefact.getAttributes();
            if (attributes == null) {
                attributes = new HashMap<String, String>();
                artefact.setAttributes(attributes);
            }
            if (attributes.containsKey("name")) continue;
            String name = null;
            if (artefact instanceof CallFunction) {
                Function function;
                CallFunction calllFunction = (CallFunction)artefact;
                if (calllFunction.getFunctionId() != null && (function = (Function)functionRepository.get(new ObjectId(calllFunction.getFunctionId()))) != null && function.getAttributes() != null && function.getAttributes().containsKey("name")) {
                    name = (String)function.getAttributes().get("name");
                }
            } else if (artefact instanceof CallPlan && (callPlan = (CallPlan)artefact).getArtefactId() != null && (calledArtefact = a.get(callPlan.getArtefactId())) != null && calledArtefact.getAttributes() != null && calledArtefact.getAttributes().containsKey("name")) {
                name = (String)calledArtefact.getAttributes().get("name");
            }
            if (name == null) {
                Artefact annotation = artefact.getClass().getAnnotation(Artefact.class);
                name = annotation.name().length() > 0 ? annotation.name() : artefact.getClass().getSimpleName();
            }
            attributes.put("name", name);
            a.save((AbstractIdentifiableObject)artefact);
        }
    }

    @Override
    public void runDowngradeScript() {
    }
}

