/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.views.functions;

import step.core.accessors.collections.ViewCounterMap;
import step.plugins.views.ViewModel;

public class ErrorDistribution
extends ViewModel {
    protected long count = 0L;
    protected long errorCount = 0L;
    protected ViewCounterMap countByErrorCode;
    protected ViewCounterMap countByErrorMsg;
    private int otherThreshhold;
    private String defaultKey;

    public ErrorDistribution(int customThreshold, String defaultKey) {
        this.otherThreshhold = customThreshold;
        this.defaultKey = defaultKey;
        this.init();
    }

    private ErrorDistribution() {
    }

    private void init() {
        this.countByErrorCode = new ViewCounterMap(this.otherThreshhold, this.defaultKey);
        this.countByErrorMsg = new ViewCounterMap(this.otherThreshhold, this.defaultKey);
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(long errorCount) {
        this.errorCount = errorCount;
    }

    public void incrementByMsg(String message) {
        this.countByErrorMsg.incrementForKey(message);
    }

    public void incrementByCode(String code) {
        this.countByErrorCode.incrementForKey(code);
    }

    public void decrementByMsg(String message) {
        this.countByErrorMsg.decrementForKey(message);
    }

    public void decrementByCode(String code) {
        this.countByErrorCode.decrementForKey(code);
    }

    public ViewCounterMap getCountByErrorCode() {
        return this.countByErrorCode;
    }

    public void setCountByErrorCode(ViewCounterMap countByErrorCode) {
        this.countByErrorCode = countByErrorCode;
    }

    public ViewCounterMap getCountByErrorMsg() {
        return this.countByErrorMsg;
    }

    public void setCountByErrorMsg(ViewCounterMap countByErrorMsg) {
        this.countByErrorMsg = countByErrorMsg;
    }
}

