/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.quotamanager;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import step.core.artefacts.reports.ReportNode;
import step.core.execution.ExecutionContext;
import step.core.plugins.IgnoreDuringAutoDiscovery;
import step.core.plugins.Plugin;
import step.core.plugins.exceptions.PluginCriticalException;
import step.engine.plugins.AbstractExecutionEnginePlugin;
import step.plugins.quotamanager.QuotaManager;

@Plugin
@IgnoreDuringAutoDiscovery
public class QuotaManagerPlugin
extends AbstractExecutionEnginePlugin {
    private final QuotaManager quotaManager;
    private final ConcurrentHashMap<String, UUID> permits = new ConcurrentHashMap();

    public QuotaManagerPlugin(QuotaManager quotaManager) {
        this.quotaManager = quotaManager;
    }

    public void beforeReportNodeExecution(ExecutionContext context, ReportNode node) {
        UUID permit;
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.putAll(context.getVariablesManager().getAllVariables());
        bindings.put("node", node);
        try {
            permit = this.quotaManager.acquirePermit(bindings);
        }
        catch (Exception e) {
            throw new PluginCriticalException("Error while getting permit from quota manager", (Throwable)e);
        }
        this.permits.put(node.getId().toString(), permit);
    }

    public void afterReportNodeExecution(ReportNode node) {
        UUID permit = this.permits.remove(node.getId().toString());
        if (permit != null) {
            this.quotaManager.releasePermit(permit);
        }
    }
}

