/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.quotamanager;

import ch.exense.commons.io.FileWatchService;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.plugins.AbstractControllerPlugin;
import step.core.plugins.Plugin;
import step.engine.plugins.ExecutionEnginePlugin;
import step.plugins.quotamanager.QuotaManager;
import step.plugins.quotamanager.QuotaManagerPlugin;
import step.plugins.quotamanager.QuotaManagerServices;

@Plugin
public class QuotaManagerControllerPlugin
extends AbstractControllerPlugin {
    private static final Logger logger = LoggerFactory.getLogger(QuotaManagerControllerPlugin.class);
    private boolean active = false;
    private FileWatchService fileWatchService;
    private QuotaManager quotaManager;

    public void executionControllerStart(GlobalContext context) {
        context.getServiceRegistrationCallback().registerService(QuotaManagerServices.class);
        String config = context.getConfiguration().getProperty("quotamanager.config");
        if (config != null) {
            this.active = true;
            QuotaManager manager = this.initQuotaManager(config);
            context.put(QuotaManager.class, (Object)manager);
        }
    }

    public ExecutionEnginePlugin getExecutionEnginePlugin() {
        if (this.active) {
            return new QuotaManagerPlugin(this.quotaManager);
        }
        return null;
    }

    private QuotaManager initQuotaManager(String config) {
        final File configFile = new File(config);
        this.quotaManager = new QuotaManager(configFile);
        this.fileWatchService = new FileWatchService();
        this.fileWatchService.register(configFile, new Runnable(){

            @Override
            public void run() {
                QuotaManagerControllerPlugin.this.quotaManager.loadConfiguration(configFile);
            }
        });
        return this.quotaManager;
    }

    public void executionControllerDestroy(GlobalContext context) {
        if (this.fileWatchService != null) {
            try {
                this.fileWatchService.close();
            }
            catch (IOException e) {
                logger.error("Error while closing file watch service", (Throwable)e);
            }
        }
        super.executionControllerDestroy(context);
    }
}

