/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.quotamanager;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.common.managedoperations.OperationManager;
import step.plugins.quotamanager.QuotaHandler;
import step.plugins.quotamanager.QuotaHandlerStatus;
import step.plugins.quotamanager.config.Quota;
import step.plugins.quotamanager.config.QuotaManagerConfig;
import step.plugins.quotamanager.config.QuotaManagerConfigParser;

public class QuotaManager {
    private static final Logger logger = LoggerFactory.getLogger(QuotaManager.class);
    private volatile QuotaManagerConfig config;
    private volatile boolean enabled = false;
    private volatile List<QuotaHandler> quotaHandlers;
    private final ConcurrentHashMap<UUID, List<Permit>> permits = new ConcurrentHashMap();
    private final Object paceLockObject = new Object();

    public QuotaManager() {
    }

    public QuotaManager(QuotaManagerConfig config) {
        this.loadConfiguration(config);
    }

    public QuotaManager(File configFile) {
        this.loadConfiguration(configFile);
    }

    public QuotaManagerConfig getConfig() {
        return this.config;
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void loadConfiguration(File configFile) {
        logger.debug("Parsing configuration from file: " + configFile.toString());
        QuotaManagerConfig config = QuotaManagerConfigParser.parseConfig(configFile);
        this.loadConfiguration(config);
    }

    public void loadConfiguration(QuotaManagerConfig config) {
        logger.debug("Loading configuration");
        this.config = config;
        this.createHandlers();
    }

    private void createHandlers() {
        this.quotaHandlers = new ArrayList<QuotaHandler>();
        if (this.config.getQuotas() != null) {
            for (Quota quota : this.config.getQuotas()) {
                if (quota.getPermits() <= 0 && quota.getAcquireTimeoutMs() == null) continue;
                QuotaHandler quotaHandler = new QuotaHandler(quota);
                this.quotaHandlers.add(quotaHandler);
            }
        }
    }

    public UUID acquirePermit(Map<String, Object> bindingVariables) throws Exception {
        return this.acquirePermit(null, bindingVariables);
    }

    public UUID acquirePermit(UUID permitID, Map<String, Object> bindingVariables) throws Exception {
        if (permitID != null && this.permits.get(permitID) != null) {
            return permitID;
        }
        logger.debug("Permit request. Binding variables: " + bindingVariables.toString());
        ArrayList<Permit> acquiredPermits = new ArrayList<Permit>();
        try {
            for (QuotaHandler quotaHandler : this.quotaHandlers) {
                try {
                    long t1 = System.currentTimeMillis();
                    OperationManager.getInstance().enter("Quota acquisition", (Object)quotaHandler.getConfig());
                    String quotaKey = quotaHandler.acquirePermit(bindingVariables);
                    if (quotaKey == null) continue;
                    long duration = System.currentTimeMillis() - t1;
                    logger.debug("Permit acquired in " + duration + "ms. QuotaKey: " + quotaKey);
                    if (quotaKey == null) continue;
                    Permit permit = new Permit(quotaHandler, quotaKey);
                    acquiredPermits.add(permit);
                }
                catch (TimeoutException e) {
                    logger.warn("A timeout occurred while trying to acquire permit for quota handler: " + quotaHandler.getConfig().toString() + ". Bindings: " + bindingVariables);
                    throw e;
                }
                finally {
                    OperationManager.getInstance().exit();
                }
            }
            UUID id = null;
            id = permitID instanceof UUID ? permitID : UUID.randomUUID();
            this.permits.put(id, acquiredPermits);
            logger.debug("Permit request succeeded. Returning permitID: " + id);
            return id;
        }
        catch (Exception e) {
            this.releasePermits(acquiredPermits);
            throw e;
        }
    }

    public void releasePermit(UUID id) {
        List<Permit> permits = this.permits.remove(id);
        if (permits != null) {
            logger.debug("Releasing permit. PermitID: " + id);
            this.releasePermits(permits);
        }
    }

    private void releasePermits(List<Permit> permits) {
        for (Permit permit : permits) {
            permit.handler.releasePermit(permit.quotaKey);
        }
    }

    public List<QuotaHandlerStatus> getStatus() {
        ArrayList<QuotaHandlerStatus> statusList = new ArrayList<QuotaHandlerStatus>();
        for (QuotaHandler quotaHandler : this.quotaHandlers) {
            statusList.add(quotaHandler.getStatus());
        }
        return statusList;
    }

    public Object getPaceLockObject() {
        return this.paceLockObject;
    }

    private class Permit {
        QuotaHandler handler;
        String quotaKey;

        public Permit(QuotaHandler manager, String quotaKey) {
            this.handler = manager;
            this.quotaKey = quotaKey;
        }
    }
}

