/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.parametermanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.artefacts.reports.ReportNode;
import step.core.execution.ExecutionContext;
import step.core.execution.ExecutionContextBindings;
import step.core.objectenricher.ObjectPredicate;
import step.core.plugins.IgnoreDuringAutoDiscovery;
import step.core.plugins.Plugin;
import step.core.variables.VariableType;
import step.core.variables.VariablesManager;
import step.engine.execution.ExecutionManager;
import step.engine.plugins.AbstractExecutionEnginePlugin;
import step.functions.Function;
import step.parameter.Parameter;
import step.parameter.ParameterManager;
import step.parameter.ParameterScope;

@Plugin(dependencies={})
@IgnoreDuringAutoDiscovery
public class ParameterManagerPlugin
extends AbstractExecutionEnginePlugin {
    private static final String PARAMETER_SCOPE_VALUE_DEFAULT = "default";
    private static final String PARAMETERS_BY_SCOPE = "$parametersByScope";
    public static final String entityName = "parameters";
    public static Logger logger = LoggerFactory.getLogger(ParameterManagerPlugin.class);
    protected final ParameterManager parameterManager;

    public ParameterManagerPlugin(ParameterManager parameterManager) {
        this.parameterManager = parameterManager;
    }

    public void executionStart(ExecutionContext context) {
        ReportNode rootNode = context.getReport();
        Map contextBindings = ExecutionContextBindings.get((ExecutionContext)context);
        ObjectPredicate objectPredicate = context.getObjectPredicate();
        Map allParameters = this.parameterManager.getAllParameters(contextBindings, objectPredicate);
        this.buildExecutionParametersMapAndUpdateExecution(context, allParameters);
        Map<ParameterScope, Map<String, List<Parameter>>> parametersByScope = this.getAllParametersByScope(allParameters);
        context.put(PARAMETERS_BY_SCOPE, parametersByScope);
        this.addScopeParametersToContext(context, rootNode, parametersByScope, ParameterScope.GLOBAL, PARAMETER_SCOPE_VALUE_DEFAULT);
    }

    public void beforeFunctionExecution(ExecutionContext context, ReportNode node, Function function) {
        Map parametersByScope = (Map)context.get((Object)PARAMETERS_BY_SCOPE);
        Map attributes = function.getAttributes();
        if (attributes != null) {
            this.addScopeParametersToContext(context, node, parametersByScope, ParameterScope.FUNCTION, (String)attributes.get("name"));
            if (attributes.containsKey("application")) {
                this.addScopeParametersToContext(context, node, parametersByScope, ParameterScope.FUNCTION, (String)attributes.get("application") + "." + (String)attributes.get("name"));
                this.addScopeParametersToContext(context, node, parametersByScope, ParameterScope.APPLICATION, (String)attributes.get("application"));
            }
        }
    }

    private void buildExecutionParametersMapAndUpdateExecution(ExecutionContext context, Map<String, Parameter> allParameters) {
        ExecutionManager executionManager = context.getExecutionManager();
        HashMap executionParameters = new HashMap();
        allParameters.forEach((k, v) -> {
            String value = v.getValue();
            if (value != null) {
                executionParameters.put(k, value);
            }
        });
        executionManager.updateParameters(context, executionParameters);
    }

    private Map<ParameterScope, Map<String, List<Parameter>>> getAllParametersByScope(Map<String, Parameter> allParameters) {
        HashMap<ParameterScope, Map<String, List<Parameter>>> parametersByScope = new HashMap<ParameterScope, Map<String, List<Parameter>>>();
        allParameters.forEach((k, v) -> {
            ParameterScope scope = v.getScope() != null ? v.getScope() : ParameterScope.GLOBAL;
            String scopeValue = v.getScopeEntity() != null ? v.getScopeEntity() : PARAMETER_SCOPE_VALUE_DEFAULT;
            parametersByScope.computeIfAbsent(scope, t -> new HashMap()).computeIfAbsent(scopeValue, t -> new ArrayList()).add(v);
        });
        return parametersByScope;
    }

    private void addScopeParametersToContext(ExecutionContext context, ReportNode node, Map<ParameterScope, Map<String, List<Parameter>>> parametersByScope, ParameterScope scope, String scopeValue) {
        List<Parameter> scopeValueSpecificParameters;
        VariablesManager varMan = context.getVariablesManager();
        Map<String, List<Parameter>> scopeSpecificParameters = parametersByScope.get(scope);
        if (scopeSpecificParameters != null && (scopeValueSpecificParameters = scopeSpecificParameters.get(scopeValue)) != null) {
            scopeValueSpecificParameters.forEach(p -> varMan.putVariable(node, VariableType.IMMUTABLE, p.getKey(), (Object)p.getValue()));
        }
    }

    public static void putVariables(ExecutionContext context, ReportNode rootNode, Map<String, ? extends Object> parameters, VariableType type) {
        VariablesManager varMan = context.getVariablesManager();
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                varMan.putVariable(rootNode, type, key, parameters.get(key));
            }
        }
    }
}

