/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.interactive;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.artefacts.ArtefactQueue;
import step.artefacts.CallFunction;
import step.artefacts.FunctionGroup;
import step.artefacts.StreamingArtefact;
import step.core.GlobalContext;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportNode;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.execution.AbstractExecutionEngineContext;
import step.core.execution.ExecutionEngine;
import step.core.execution.ExecutionEngineContext;
import step.core.execution.OperationMode;
import step.core.execution.model.ExecutionAccessor;
import step.core.execution.model.ExecutionParameters;
import step.core.execution.model.InMemoryExecutionAccessor;
import step.core.objectenricher.ObjectHookRegistry;
import step.core.plans.Plan;
import step.core.plans.PlanAccessor;
import step.core.plans.PlanNavigator;
import step.core.plans.builder.PlanBuilder;
import step.core.plans.runner.PlanRunnerResult;
import step.engine.plugins.AbstractExecutionEnginePlugin;
import step.engine.plugins.ExecutionEnginePlugin;
import step.functions.Function;
import step.functions.execution.FunctionExecutionServiceException;
import step.functions.manager.FunctionManager;
import step.grid.client.AbstractGridClientImpl;
import step.parameter.ParameterManager;
import step.planbuilder.FunctionArtefacts;
import step.plugins.parametermanager.ParameterManagerPlugin;

@Singleton
@Path(value="interactive")
public class InteractiveServices
extends AbstractServices {
    private static final Logger logger = LoggerFactory.getLogger(InteractiveServices.class);
    private Map<String, InteractiveSession> sessions = new ConcurrentHashMap<String, InteractiveSession>();
    private Timer sessionExpirationTimer;
    private ExecutionEngine executionEngine;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private PlanAccessor planAccessor;

    public InteractiveServices() {
        this.sessionExpirationTimer = new Timer("Session expiration timer");
        this.sessionExpirationTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                int sessionTimeout = InteractiveServices.this.configuration.getPropertyAsInteger("ui.artefacteditor.interactive.sessiontimeout.minutes", Integer.valueOf(10)) * 60000;
                long time = System.currentTimeMillis();
                InteractiveServices.this.sessions.forEach((sessionId, session) -> {
                    if (session.lasttouch + (long)sessionTimeout < time) {
                        try {
                            InteractiveServices.this.closeSession(session);
                        }
                        catch (FunctionExecutionServiceException functionExecutionServiceException) {
                            // empty catch block
                        }
                        InteractiveServices.this.sessions.remove(sessionId);
                    }
                });
            }
        }, 60000L, 60000L);
    }

    @PostConstruct
    public void init() throws Exception {
        super.init();
        GlobalContext context = this.getContext();
        this.planAccessor = context.getPlanAccessor();
        ObjectHookRegistry objectHookRegistry = (ObjectHookRegistry)context.require(ObjectHookRegistry.class);
        this.executionEngine = ExecutionEngine.builder().withOperationMode(OperationMode.CONTROLLER).withParentContext((AbstractExecutionEngineContext)context).withPluginsFromClasspath().withPlugin((ExecutionEnginePlugin)new AbstractExecutionEnginePlugin(){

            public void initializeExecutionEngineContext(AbstractExecutionEngineContext parentContext, ExecutionEngineContext executionEngineContext) {
                executionEngineContext.setExecutionAccessor((ExecutionAccessor)new InMemoryExecutionAccessor());
            }
        }).withPlugin((ExecutionEnginePlugin)new ParameterManagerPlugin((ParameterManager)context.get(ParameterManager.class))).withObjectHookRegistry(objectHookRegistry).build();
    }

    @PreDestroy
    private void close() {
        if (this.sessionExpirationTimer != null) {
            this.sessionExpirationTimer.cancel();
        }
        this.executorService.shutdown();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/start")
    @Secured(right="interactive")
    public String start(ExecutionParameters executionParameters) throws AbstractGridClientImpl.AgentCommunicationException {
        StreamingArtefact streamingArtefact = new StreamingArtefact();
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)FunctionArtefacts.session()).add((AbstractArtefact)streamingArtefact).endBlock().build();
        executionParameters.setPlan(plan);
        String executionId = this.executionEngine.initializeExecution(executionParameters);
        Future<PlanRunnerResult> future = this.executorService.submit(() -> this.executionEngine.execute(executionId));
        InteractiveSession session = new InteractiveSession(streamingArtefact.getQueue(), future);
        this.sessions.put(executionId, session);
        return executionId;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/stop")
    @Secured(right="interactive")
    public void stop(@PathParam(value="id") String sessionId) throws FunctionExecutionServiceException, InterruptedException, ExecutionException {
        InteractiveSession session = this.getAndTouchSession(sessionId);
        if (session != null) {
            this.closeSession(session);
            session.getFuture().get();
        }
    }

    private void closeSession(InteractiveSession session) throws FunctionExecutionServiceException {
        session.getArtefactQueue().stop();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/execute/{planid}/{artefactid}")
    @Secured(right="interactive")
    public ReportNode executeArtefact(@PathParam(value="id") String sessionId, @PathParam(value="planid") String planId, @PathParam(value="artefactid") String artefactId, @Context ContainerRequestContext crc) throws InterruptedException, ExecutionException {
        InteractiveSession session = this.getAndTouchSession(sessionId);
        if (session != null) {
            AbstractArtefact artefact = this.findArtefactInPlan(planId, artefactId);
            Future future = session.getArtefactQueue().add(artefact);
            ReportNode reportNode = (ReportNode)future.get();
            return reportNode;
        }
        throw new RuntimeException("Session doesn't exist or expired.");
    }

    protected AbstractArtefact findArtefactInPlan(String planId, String artefactId) {
        Plan plan = (Plan)this.planAccessor.get(planId);
        AbstractArtefact artefact = new PlanNavigator(plan).findArtefactById(artefactId);
        return artefact;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/functiontest/{keywordid}/start")
    @Secured(right="interactive")
    public FunctionTestingSession startFunctionTestingSession(@PathParam(value="keywordid") String keywordid) throws AbstractGridClientImpl.AgentCommunicationException {
        CallFunction callFunction = FunctionArtefacts.keywordById((String)keywordid, (String)"{}");
        FunctionManager functionManager = (FunctionManager)this.getContext().get(FunctionManager.class);
        Function function = functionManager.getFunctionById(keywordid);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", (String)function.getAttributes().get("name"));
        callFunction.setAttributes(attributes);
        FunctionGroup functionGroup = new FunctionGroup();
        attributes = new HashMap();
        attributes.put("name", "Session");
        functionGroup.setAttributes(attributes);
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)functionGroup).add((AbstractArtefact)callFunction).endBlock().build();
        plan.setVisible(false);
        this.getContext().getPlanAccessor().save((AbstractIdentifiableObject)plan);
        FunctionTestingSession result = new FunctionTestingSession();
        result.setPlanId(plan.getId().toString());
        result.setCallFunctionId(callFunction.getId().toString());
        return result;
    }

    private InteractiveSession getAndTouchSession(String sessionId) {
        InteractiveSession session = this.sessions.get(sessionId);
        if (session != null) {
            session.lasttouch = System.currentTimeMillis();
        }
        return session;
    }

    public static class FunctionTestingSession {
        private String planId;
        private String callFunctionId;

        public String getPlanId() {
            return this.planId;
        }

        public void setPlanId(String planId) {
            this.planId = planId;
        }

        public String getCallFunctionId() {
            return this.callFunctionId;
        }

        public void setCallFunctionId(String callFunctionId) {
            this.callFunctionId = callFunctionId;
        }
    }

    private static class InteractiveSession {
        long lasttouch;
        private final ArtefactQueue artefactQueue;
        private final Future<PlanRunnerResult> future;

        public InteractiveSession(ArtefactQueue artefactQueue, Future<PlanRunnerResult> future) {
            this.artefactQueue = artefactQueue;
            this.future = future;
            this.lasttouch = System.currentTimeMillis();
        }

        protected ArtefactQueue getArtefactQueue() {
            return this.artefactQueue;
        }

        protected Future<PlanRunnerResult> getFuture() {
            return this.future;
        }
    }
}

