/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.datatable;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.AbstractContext;
import step.core.accessors.collections.Collection;
import step.core.accessors.collections.CollectionFind;
import step.core.accessors.collections.CollectionRegistry;
import step.core.accessors.collections.SearchOrder;
import step.core.accessors.collections.field.CollectionField;
import step.core.deployment.ApplicationServices;
import step.core.deployment.JacksonMapperProvider;
import step.core.deployment.Secured;
import step.core.export.ExportTaskManager;
import step.core.objectenricher.ObjectHookRegistry;
import step.core.ql.OQLMongoDBBuilder;
import step.plugins.datatable.DataTableResponse;
import step.resources.Resource;
import step.resources.ResourceRevisionContainer;

@Singleton
@Path(value="table")
public class TableService
extends ApplicationServices {
    private static final Logger logger = LoggerFactory.getLogger(TableService.class);
    private ObjectHookRegistry objectHookRegistry;
    protected CollectionRegistry collectionRegistry;
    protected MongoDatabase database;
    protected int maxTime;
    protected ExportTaskManager exportTaskManager;
    private ObjectMapper webLayerObjectMapper = JacksonMapperProvider.createMapper();
    private Pattern columnSearchPattern = Pattern.compile("columns\\[([0-9]+)\\]\\[search\\]\\[value\\]");
    private Pattern searchPattern = Pattern.compile("search\\[value\\]");
    private Pattern namePattern = Pattern.compile("columns\\[([0-9]+)\\]\\[name\\]");

    @PostConstruct
    public void init() throws Exception {
        super.init();
        this.database = this.getContext().getMongoClientSession().getMongoDatabase();
        this.collectionRegistry = (CollectionRegistry)this.getContext().get(CollectionRegistry.class);
        this.maxTime = this.controller.getContext().getConfiguration().getPropertyAsInteger("db.query.maxTime", Integer.valueOf(30));
        this.objectHookRegistry = (ObjectHookRegistry)this.getContext().get(ObjectHookRegistry.class);
        this.exportTaskManager = new ExportTaskManager(this.getContext().getResourceManager());
    }

    @PreDestroy
    public void destroy() {
    }

    @POST
    @Path(value="/{id}/data")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Secured
    public DataTableResponse getTableData_Post(@PathParam(value="id") String collectionID, MultivaluedMap<String, String> form, @Context UriInfo uriInfo) throws Exception {
        if (uriInfo.getQueryParameters() != null) {
            form.putAll((Map)uriInfo.getQueryParameters());
        }
        Bson sessionQueryFragment = this.getAdditionalQueryFragmentFromContext(collectionID);
        return this.getTableData(collectionID, form, sessionQueryFragment);
    }

    @GET
    @Path(value="/{id}/data")
    @Produces(value={"application/json"})
    @Secured
    public DataTableResponse getTableData_Get(@PathParam(value="id") String collectionID, @Context UriInfo uriInfo) throws Exception {
        Bson sessionQueryFragment = this.getAdditionalQueryFragmentFromContext(collectionID);
        return this.getTableData(collectionID, (MultivaluedMap<String, String>)uriInfo.getQueryParameters(), sessionQueryFragment);
    }

    @GET
    @Path(value="/{id}/column/{column}/distinct")
    @Produces(value={"application/json"})
    @Secured
    public List<String> getTableColumnDistinct(@PathParam(value="id") String collectionID, @PathParam(value="column") String column, @Context UriInfo uriInfo) throws Exception {
        Collection collection = this.collectionRegistry.get(collectionID);
        return collection.distinct(column);
    }

    @POST
    @Path(value="/{id}/searchIdsBy/{column}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Secured
    public List<String> searchIdsBy(@PathParam(value="id") String collectionID, @PathParam(value="column") String columnName, String searchValue) throws Exception {
        Collection collection = this.collectionRegistry.get(collectionID);
        Bson columnQueryFragment = collection.getQueryFragmentForColumnSearch(columnName, searchValue);
        return collection.distinct("_id", columnQueryFragment);
    }

    private DataTableResponse getTableData(@PathParam(value="id") String collectionID, MultivaluedMap<String, String> params, Bson sessionQueryFragment) throws Exception {
        List additionalQueryFragments;
        Collection collection = this.collectionRegistry.get(collectionID);
        if (collection == null) {
            throw new RuntimeException("The collection " + collectionID + " doesn't exist");
        }
        Map<Integer, String> columnNames = this.getColumnNamesMap(params);
        List<Bson> queryFragments = this.createQueryFragments(params, columnNames, collection);
        int draw = Integer.parseInt((String)params.getFirst((Object)"draw"));
        int skip = Integer.parseInt((String)params.getFirst((Object)"start"));
        int limit = Integer.parseInt((String)params.getFirst((Object)"length"));
        int sortColumnID = Integer.parseInt((String)params.getFirst((Object)"order[0][column]"));
        String sortColumnName = columnNames.get(sortColumnID);
        String sortDir = (String)params.getFirst((Object)"order[0][dir]");
        SearchOrder order = sortColumnName != null && !sortColumnName.isEmpty() ? new SearchOrder(sortColumnName, sortDir.equals("asc") ? 1 : -1) : null;
        if (collection.isFiltered() && sessionQueryFragment != null) {
            queryFragments.add(sessionQueryFragment);
        }
        JsonObject queryParameters = null;
        if (params.containsKey((Object)"params")) {
            JsonReader reader = Json.createReader((Reader)new StringReader((String)params.getFirst((Object)"params")));
            queryParameters = reader.readObject();
        }
        if ((additionalQueryFragments = collection.getAdditionalQueryFragments(queryParameters)) != null) {
            queryFragments.addAll(additionalQueryFragments);
        }
        Bson query = queryFragments.size() > 0 ? Filters.and(queryFragments) : new Document();
        CollectionFind find = collection.find(query, order, Integer.valueOf(skip), Integer.valueOf(limit), this.maxTime);
        ArrayList objects = new ArrayList();
        Iterator iterator = find.getIterator();
        while (iterator.hasNext()) {
            objects.add(iterator.next());
        }
        String[][] data = new String[objects.size()][1];
        for (int i = 0; i < objects.size(); ++i) {
            Object row = objects.get(i);
            String[] rowFormatted = new String[columnNames.size()];
            try {
                String rowAsString;
                rowFormatted[0] = rowAsString = this.webLayerObjectMapper.writeValueAsString(row);
            }
            catch (Exception e) {
                logger.error("Error while serializing " + row, (Throwable)e);
                throw e;
            }
            data[i] = rowFormatted;
        }
        DataTableResponse response = new DataTableResponse(draw, find.getRecordsTotal(), find.getRecordsFiltered(), data);
        return response;
    }

    @GET
    @Path(value="/{id}/export")
    @Produces(value={"application/json"})
    @Secured
    public String createExport(@PathParam(value="id") String collectionID, @Context UriInfo uriInfo) throws Exception {
        List queryFragments;
        MultivaluedMap params = uriInfo.getQueryParameters();
        Collection collection = this.collectionRegistry.get(collectionID);
        if (collection == null) {
            throw new RuntimeException("The collection " + collectionID + " doesn't exist");
        }
        JsonObject queryParameters = null;
        if (params.containsKey((Object)"params")) {
            JsonReader reader = Json.createReader((Reader)new StringReader((String)params.getFirst((Object)"params")));
            queryParameters = reader.readObject();
        }
        Bson query = (queryFragments = collection.getAdditionalQueryFragments(queryParameters)).size() > 0 ? Filters.and((Iterable)queryFragments) : new Document();
        String exportID = UUID.randomUUID().toString();
        this.exportTaskManager.createExportTask(exportID, (ExportTaskManager.ExportRunnable)new ExportTask(collection, null, query));
        return "{\"exportID\":\"" + exportID + "\"}";
    }

    @GET
    @Path(value="/exports/{id}")
    @Produces(value={"application/json"})
    @Secured
    public ExportTaskManager.ExportStatus getExport(@PathParam(value="id") String reportID) throws Exception {
        return this.exportTaskManager.getExportStatus(reportID);
    }

    private List<Bson> createQueryFragments(MultivaluedMap<String, String> params, Map<Integer, String> columnNames, Collection<?> collection) {
        ArrayList<Bson> queryFragments = new ArrayList<Bson>();
        for (String key : params.keySet()) {
            String searchValue;
            Matcher m = this.columnSearchPattern.matcher(key);
            Matcher searchMatcher = this.searchPattern.matcher(key);
            if (m.matches()) {
                int columnID = Integer.parseInt(m.group(1));
                String columnName = columnNames.get(columnID);
                String searchValue2 = (String)params.getFirst((Object)key);
                if (searchValue2 == null || searchValue2.length() <= 0) continue;
                Bson columnQueryFragment = collection.getQueryFragmentForColumnSearch(columnName, searchValue2);
                queryFragments.add(columnQueryFragment);
                continue;
            }
            if (searchMatcher.matches() && (searchValue = (String)params.getFirst((Object)key)) != null && searchValue.length() <= 0) continue;
        }
        if (params.containsKey((Object)"filter")) {
            Bson filter = OQLMongoDBBuilder.build((String)((String)params.getFirst((Object)"filter")));
            queryFragments.add(filter);
        }
        return queryFragments;
    }

    private Map<Integer, String> getColumnNamesMap(MultivaluedMap<String, String> params) {
        HashMap<Integer, String> columnNames = new HashMap<Integer, String>();
        for (String key : params.keySet()) {
            Matcher m = this.namePattern.matcher(key);
            if (!m.matches()) continue;
            int columnID = Integer.parseInt(m.group(1));
            String columnName = (String)params.getFirst((Object)key);
            columnNames.put(columnID, columnName);
        }
        return columnNames;
    }

    private Bson getAdditionalQueryFragmentFromContext(String collectionID) {
        Bson query = OQLMongoDBBuilder.build((String)this.objectHookRegistry.getObjectFilter((AbstractContext)this.getSession()).getOQLFilter());
        return query;
    }

    public static class ExportTask
    extends ExportTaskManager.ExportRunnable {
        protected Collection<?> collection;
        protected Map<String, CollectionField> columns;
        protected Bson query;

        public ExportTask(Collection<?> collection, Map<String, CollectionField> columns, Bson query) {
            this.collection = collection;
            this.columns = columns;
            this.query = query;
        }

        protected Resource runExport() throws Exception {
            try {
                ResourceRevisionContainer resourceContainer = this.getResourceManager().createResourceContainer("temp", "export.csv");
                PrintWriter writer = new PrintWriter(resourceContainer.getOutputStream());
                try {
                    this.collection.export(this.query, this.columns, writer);
                }
                finally {
                    writer.close();
                    resourceContainer.save(null);
                }
                return resourceContainer.getResource();
            }
            catch (Exception e) {
                logger.error("An error occurred while generating report", (Throwable)e);
                throw e;
            }
        }
    }
}

