/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.views.functions;

import java.util.Map;
import step.artefacts.reports.CallFunctionReportNode;
import step.core.artefacts.reports.ReportNode;
import step.plugins.views.View;
import step.plugins.views.functions.AbstractTimeBasedModel;
import step.plugins.views.functions.AbstractTimeBasedView;
import step.plugins.views.functions.ReportNodeStatisticsEntry;

@View
public class ReportNodeStatisticsView
extends AbstractTimeBasedView<ReportNodeStatisticsEntry> {
    @Override
    public void afterReportNodeSkeletonCreation(AbstractTimeBasedModel<ReportNodeStatisticsEntry> model, ReportNode node) {
    }

    private ReportNodeStatisticsEntry createPoint(ReportNode node) {
        ReportNodeStatisticsEntry e = null;
        if (node instanceof CallFunctionReportNode && node.persistNode()) {
            e = new ReportNodeStatisticsEntry();
            e.count = 1;
            e.sum = node.getDuration().intValue();
            ReportNodeStatisticsEntry.Statistics stats = new ReportNodeStatisticsEntry.Statistics(1, node.getDuration().intValue());
            Map functionAttributes = ((CallFunctionReportNode)node).getFunctionAttributes();
            if (functionAttributes != null) {
                e.byFunctionName.put((String)functionAttributes.get("name"), stats);
            }
        }
        return e;
    }

    @Override
    public void afterReportNodeExecution(AbstractTimeBasedModel<ReportNodeStatisticsEntry> model, ReportNode node) {
        ReportNodeStatisticsEntry e = this.createPoint(node);
        if (e != null) {
            this.addPoint(model, node.getExecutionTime(), e);
        }
    }

    @Override
    protected void mergePoints(ReportNodeStatisticsEntry target, ReportNodeStatisticsEntry source) {
        target.count += source.count;
        target.sum += source.sum;
        for (Map.Entry<String, ReportNodeStatisticsEntry.Statistics> e : source.byFunctionName.entrySet()) {
            ReportNodeStatisticsEntry.Statistics stats = target.byFunctionName.get(e.getKey());
            if (stats == null) {
                stats = e.getValue();
            } else {
                stats.count += e.getValue().count;
                stats.sum += e.getValue().sum;
            }
            target.byFunctionName.put(e.getKey(), stats);
        }
    }

    @Override
    protected void unMergePoints(ReportNodeStatisticsEntry target, ReportNodeStatisticsEntry source) {
        target.count -= source.count;
        target.sum -= source.sum;
        for (Map.Entry<String, ReportNodeStatisticsEntry.Statistics> e : source.byFunctionName.entrySet()) {
            ReportNodeStatisticsEntry.Statistics stats = target.byFunctionName.get(e.getKey());
            if (stats == null) continue;
            stats.count -= e.getValue().count;
            stats.sum -= e.getValue().sum;
            target.byFunctionName.put(e.getKey(), stats);
        }
    }

    @Override
    public String getViewId() {
        return "ReportNodeStatistics";
    }

    @Override
    public void rollbackReportNode(AbstractTimeBasedModel<ReportNodeStatisticsEntry> model, ReportNode node) {
        ReportNodeStatisticsEntry e = this.createPoint(node);
        if (e != null) {
            this.removePoint(model, node.getExecutionTime(), e);
        }
    }
}

