/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.views;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.artefacts.reports.ReportNode;
import step.core.execution.ExecutionContext;
import step.core.plugins.AbstractControllerPlugin;
import step.core.plugins.Plugin;
import step.plugins.views.AbstractView;
import step.plugins.views.View;
import step.plugins.views.ViewModel;
import step.plugins.views.ViewModelAccessor;
import step.plugins.views.ViewModelAccessorImpl;
import step.plugins.views.ViewPluginServices;

@Plugin
public class ViewPlugin
extends AbstractControllerPlugin {
    private static Logger logger = LoggerFactory.getLogger(ViewPlugin.class);
    public static final String VIEW_PLUGIN_KEY = "ViewPlugin_Instance";
    private final ConcurrentHashMap<String, AbstractView<ViewModel>> register = new ConcurrentHashMap();
    private ViewModelAccessor accessor;

    public void executionControllerStart(GlobalContext context) {
        this.loadViews();
        this.accessor = new ViewModelAccessorImpl(context.getMongoClientSession());
        context.put(ViewModelAccessor.class, (Object)this.accessor);
        context.getServiceRegistrationCallback().registerService(ViewPluginServices.class);
        context.put(VIEW_PLUGIN_KEY, (Object)this);
    }

    private void loadViews() {
        Set viewClasses = new Reflections("step", new Scanner[0]).getTypesAnnotatedWith(View.class);
        for (Class viewClass : viewClasses) {
            try {
                AbstractView view = (AbstractView)viewClass.newInstance();
                this.register(view.getViewId(), view);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {}
        }
    }

    public void register(String viewId, AbstractView<ViewModel> view) {
        this.register.put(viewId, view);
    }

    public ViewModel query(String viewId, String executionId) {
        AbstractView<ViewModel> view = this.register.get(viewId);
        if (view != null) {
            ViewModel model = view.getModel(executionId);
            if (model == null) {
                model = this.accessor.get(viewId, executionId, ViewModel.class);
                if (model != null) {
                    return model;
                }
                return view.init();
            }
            return model;
        }
        throw new RuntimeException("Invalid view id: " + viewId);
    }

    public void executionStart(ExecutionContext context) {
        for (AbstractView<ViewModel> view : this.register.values()) {
            try {
                ViewModel model = view.init();
                model.setExecutionId(context.getExecutionId());
                model.setViewId(view.getViewId());
                view.addModel(context.getExecutionId(), model);
            }
            catch (Exception e) {
                logger.error("Error while initializing view " + view.getViewId(), (Throwable)e);
            }
        }
    }

    public void afterExecutionEnd(ExecutionContext context) {
        for (AbstractView<ViewModel> view : this.register.values()) {
            try {
                ViewModel model = view.removeModel(context.getExecutionId());
                this.accessor.save(model);
            }
            catch (Exception e) {
                logger.error("Error while saving view " + view.getViewId(), (Throwable)e);
            }
        }
    }

    public void afterReportNodeSkeletonCreation(ReportNode node) {
        this.invokeViewHooks(node, (model, view) -> view.afterReportNodeSkeletonCreation(model, node));
    }

    public void afterReportNodeExecution(ReportNode node) {
        this.invokeViewHooks(node, (model, view) -> view.afterReportNodeExecution(model, node));
    }

    public void rollbackReportNode(ReportNode node) {
        this.invokeViewHooks(node, (model, view) -> view.rollbackReportNode(model, node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeViewHooks(ReportNode node, BiConsumer<ViewModel, AbstractView<ViewModel>> consumer) {
        for (AbstractView<ViewModel> view : this.register.values()) {
            ViewModel model;
            ViewModel viewModel = model = view.getModel(node.getExecutionID());
            synchronized (viewModel) {
                try {
                    consumer.accept(model, view);
                }
                catch (Exception e) {
                    logger.error("Error while invoking view " + view.getViewId() + " for node " + node.toString(), (Throwable)e);
                }
            }
        }
    }
}

