/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.screentemplating;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.bson.types.ObjectId;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.deployment.Session;
import step.core.deployment.Unfiltered;
import step.plugins.screentemplating.Input;
import step.plugins.screentemplating.ScreenInput;
import step.plugins.screentemplating.ScreenInputAccessor;
import step.plugins.screentemplating.ScreenTemplateManager;

@Singleton
@Path(value="screens")
public class ScreenTemplateService
extends AbstractServices {
    protected ScreenTemplateManager screenTemplateManager;
    protected ScreenInputAccessor screenInputAccessor;

    @PostConstruct
    public void init() throws Exception {
        super.init();
        this.screenInputAccessor = (ScreenInputAccessor)this.getContext().get(ScreenInputAccessor.class);
        this.screenTemplateManager = (ScreenTemplateManager)this.getContext().get(ScreenTemplateManager.class);
    }

    @GET
    @Secured
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public List<Input> getInputsForScreen(@PathParam(value="id") String screenId, @Context UriInfo uriInfo, @Context ContainerRequestContext crc) {
        Map<String, Object> contextBindings = this.getContextBindings(uriInfo, crc);
        return this.screenTemplateManager.getInputsForScreen(screenId, contextBindings);
    }

    @GET
    @Secured
    @Path(value="/{screenid}/{inputid}")
    @Produces(value={"application/json"})
    public Input getInputForScreen(@PathParam(value="screenid") String screenId, @PathParam(value="inputid") String inputId, @Context UriInfo uriInfo, @Context ContainerRequestContext crc) {
        return this.getInputsForScreen(screenId, uriInfo, crc).stream().filter(i -> i.getId().equals(inputId)).findFirst().orElse(null);
    }

    @GET
    @Secured
    @Unfiltered
    @Path(value="/input/byscreen/{screenid}")
    @Produces(value={"application/json"})
    public List<ScreenInput> getScreenInputsByScreenId(@PathParam(value="screenid") String screenId) {
        return this.screenInputAccessor.getScreenInputsByScreenId(screenId);
    }

    @GET
    @Secured
    @Unfiltered
    @Path(value="/input/{id}")
    @Produces(value={"application/json"})
    public ScreenInput getInput(@PathParam(value="id") String id) {
        return (ScreenInput)this.screenInputAccessor.get(new ObjectId(id));
    }

    @DELETE
    @Secured(right="admin")
    @Path(value="/input/{id}")
    @Produces(value={"application/json"})
    public void deleteInput(@PathParam(value="id") String id) {
        this.screenInputAccessor.remove(new ObjectId(id));
        this.screenTemplateManager.notifyChange();
    }

    @POST
    @Secured(right="admin")
    @Unfiltered
    @Path(value="/input")
    @Produces(value={"application/json"})
    public void saveInput(ScreenInput screenInput) {
        this.screenInputAccessor.save((AbstractIdentifiableObject)screenInput);
        this.screenTemplateManager.notifyChange();
    }

    private Map<String, Object> getContextBindings(UriInfo uriInfo, ContainerRequestContext crc) {
        HashMap<String, Object> contextBindings = new HashMap<String, Object>();
        Session session = (Session)crc.getProperty("session");
        if (session != null) {
            contextBindings.put("user", session.getUsername());
            if (session.getProfile() != null) {
                contextBindings.put("role", session.getProfile().getRole());
            }
        }
        for (String key : uriInfo.getQueryParameters().keySet()) {
            contextBindings.put(key, uriInfo.getQueryParameters().getFirst((Object)key));
        }
        return contextBindings;
    }
}

